package ru.yandex.direct.jobs.agencyofflinereport;

/**
 * Инкапсулирует информацию о столбце
 */
class ColumnMetaInfo {
    /**
     * тип столбца, один из {@link java.sql.Types}
     */
    private final int jdbcType;

    /**
     * имя столбца в ResultSet
     */
    private final String rsColumnName;

    /**
     * Порядковый номер столбца в Excel-файле
     */
    private final int xlsReportIndex;

    /**
     * Человеко-читаемое название столбца
     */
    private final String humanReadableName;

    ColumnMetaInfo(int jdbcType, String rsColumnName, int xlsReportIndex, String humanReadableName) {
        this.jdbcType = jdbcType;
        this.rsColumnName = rsColumnName;
        this.xlsReportIndex = xlsReportIndex;
        this.humanReadableName = humanReadableName;
    }

    int getJdbcType() {
        return jdbcType;
    }

    String getRsColumnName() {
        return rsColumnName;
    }

    int getXlsReportIndex() {
        return xlsReportIndex;
    }

    String getHumanReadableName() {
        return humanReadableName;
    }
}
