package ru.yandex.direct.jobs.agencyofflinereport;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;

/**
 * Переводы к названиям столбцов XLS оффлайн-отчета по работе агентств
 */
public interface ReportColumnNameTranslations extends TranslationBundle {

    ReportColumnNameTranslations INSTANCE = I18NBundle.implement(ReportColumnNameTranslations.class);

    @TranslationStub("ID клиента")
    Translatable clientId();

    @TranslationStub("Логин клиента")
    Translatable clientLogin();

    @TranslationStub("Город клиента")
    Translatable clientCity();

    @TranslationStub("Дата создания клиента")
    Translatable clientCreateDate();

    @TranslationStub("ID агентства")
    Translatable agencyId();

    @TranslationStub("Название агентства")
    Translatable agencyName();

    @TranslationStub("Город агентства")
    Translatable agencyCity();

    @TranslationStub("Дата создания агентства")
    Translatable agencyCreateDate();

    @TranslationStub("Логин менеджера")
    Translatable agencyManagerLogin();

    @TranslationStub("Имя менеджера")
    Translatable agencyManagerName();

    @TranslationStub("Логин представителя")
    Translatable representativeLogin();

    @TranslationStub("Показы")
    Translatable impressions();

    @TranslationStub("Показы на поиске")
    Translatable searchImpressions();

    @TranslationStub("Показы в РСЯ")
    Translatable networkImpressions();

    @TranslationStub("Клики")
    Translatable clicks();

    @TranslationStub("Клики на поиске")
    Translatable searchClicks();

    @TranslationStub("Клики в РСЯ")
    Translatable networkClicks();

    @TranslationStub("Расходы по всем кампаниям")
    Translatable cost();

    @TranslationStub("Расходы на поиске")
    Translatable searchCost();

    @TranslationStub("Расходы в РСЯ")
    Translatable networkCost();

    @TranslationStub("Расходы на кампании \"Смарт-баннеры\"")
    Translatable smartBannersCost();

    @TranslationStub("Расходы по кампаниям \"Динамические объявления\"")
    Translatable dynamicAdsCost();

    @TranslationStub("Расходы по кампаниям \"Реклама мобильных приложений\"")
    Translatable mobileAppAdsCost();

    @TranslationStub("Расходы по медийным кампаниям")
    Translatable displayCampaignsCost();

    @TranslationStub("Расходы на кампании \"Баннер на поиске\"")
    Translatable searchBannerCost();

    @TranslationStub("Расходы на десктопе")
    Translatable desktopCost();

    @TranslationStub("Расходы на мобильных устройствах")
    Translatable mobileCost();

    @TranslationStub("Расходы на показы по дополнительным релевантным фразам и синонимам")
    Translatable relevantKeywordsCost();

    @TranslationStub("CTR")
    Translatable ctr();

    @TranslationStub("CTR на поиске")
    Translatable searchCtr();

    @TranslationStub("CTR в РСЯ")
    Translatable networkCtr();

    @TranslationStub("Показы на мобильном поиске")
    Translatable mobileSearchImpressions();

    @TranslationStub("Клики на мобильном поиске")
    Translatable mobileSearchClicks();

    @TranslationStub("Расходы на мобильном поиске")
    Translatable mobileSearchCost();

    @TranslationStub("CTR на мобильном поиске")
    Translatable mobileSearchCtr();

    @TranslationStub("Клиентов с остановкой кампании")
    Translatable numberOfCliensWithStops();

    @TranslationStub("Максимальный период остановки кампании в днях")
    Translatable maxClientIdleInDays();

    @TranslationStub("Клиентов с подключенным общим счётом")
    Translatable numberOfClientsHasWallet();

    @TranslationStub("Среднее количество кампаний")
    Translatable averageCampaignsCount();

    @TranslationStub("Среднее количество кампаний \"Текстово-графические объявления\"")
    Translatable averageTextAndImageAdsCampaignsCount();

    @TranslationStub("Среднее количество кампаний \"Смарт-баннеры\"")
    Translatable averageSmartBannersCampaignsCount();

    @TranslationStub("Среднее количество кампаний \"Динамические объявления\"")
    Translatable averageDynamicAdsCampaignsCount();

    @TranslationStub("Среднее количество кампаний \"Реклама мобильных приложений\"")
    Translatable averageMobileAppAdsCampaignsCount();

    @TranslationStub("Среднее количество кампаний \"Баннер на поиске\"")
    Translatable averageSearchBannerCampaignsCount();

    @TranslationStub("Среднее количество медийных кампаний")
    Translatable averageDisplayCampaignsCount();

    @TranslationStub("Среднее количество нединамических кампаний (текстово-графические объявления, реклама мобильных приложений, баннер на поиске) с показами на поиске")
    Translatable averageSearchEnabledNonDynamicCampaignsCount();

    @TranslationStub("Среднее количество нединамических кампаний (текстово-графические объявления, реклама мобильных приложений, медийная) с показами в РСЯ")
    Translatable averageNetworkEnabledNonDynamicCampaignsCount();

    @TranslationStub("Среднее количество нединамических кампаний (текстово-графические объявления, реклама мобильных приложений, баннер на поиске) с разрешенными показами и на поиске, и в РСЯ")
    Translatable averageSearchAndNetworkEnabledNonDynamicCampaignsCount();

    @TranslationStub("Среднее количество нединамических кампаний (текстово-графические объявления, реклама мобильных приложений, медийная) с показами только в РСЯ")
    Translatable averageNetworkOnlyNonDynamicCampaignsCount();

    @TranslationStub("Среднее количество кампаний со стратегией \"Недельный бюджет\"")
    Translatable averageNumberOfCampaignsWithAutobudget();

    @TranslationStub("Среднее количество кампаний, в которых указана цель (для CPA/ROI стратегий или оптимизации дополнительных релевантных фраз)")
    Translatable averageNumberOfCampaignsWithGoal();

    @TranslationStub("Среднее количество кампаний, использующих дополнительные релевантные фразы")
    Translatable averageNumberOfCampaignsWithRelevantKeywords();

    @TranslationStub("Среднее количество кампаний с настроенным временным таргетингом")
    Translatable averageNumberOfCampaignsWithTimetarget();

    @TranslationStub("Среднее количество кампаний с указанным счётчиком Метрики")
    Translatable averageNumberOfCampaignsWithMetrika();

    @TranslationStub("Среднее количество кампаний с подключенным Openstat")
    Translatable averageNumberOfCampaignsWithOpenstatEnabled();

    @TranslationStub("Среднее количество групп")
    Translatable averageNumberOfAdGroups();

    @TranslationStub("Среднее количество групп в кампаниях \"Текстово-графические объявления\"")
    Translatable averageNumberOfTextAndImageAdsAdGroups();

    @TranslationStub("Среднее количество групп в кампаниях \"Текстово-графические объявления\" с показами в сетях")
    Translatable averageNumberOfAdGroupsWithinTextAndImageAdsCampaignsWithNetworkEnabled();

    @TranslationStub("Среднее количество групп в кампаниях \"Реклама мобильных приложений\" с показами в РСЯ")
    Translatable averageNumberOfMobileAppAdGroupsWithNetworkEnabled();

    @TranslationStub("Среднее количество групп с десктопными объявлениями")
    Translatable averageNumberOfAdGroupsWithDesktopBanners();

    @TranslationStub("Среднее количество групп с мобильными объявлениями")
    Translatable averageNumberOfAdGroupsWithMobileBanners();

    @TranslationStub("Среднее количество групп с условиями ретаргетинга и подбора аудитории")
    Translatable averageNumberOfAdGroupsWithRetargetingConditions();

    @TranslationStub("Среднее количество групп с условиями ретаргетинга и подбора аудитории по сегментам Яндекс.Аудиторий")
    Translatable averageNumberOfAdGroupsWithAudienceConditions();

    @TranslationStub("Среднее количество групп с повышающими корректировками для мобильных устройств")
    Translatable averageNumberOfAdGroupsWithIncreasingMobileAdjustments();

    @TranslationStub("Среднее количество групп с понижающими корректировками для мобильных устройств")
    Translatable averageNumberOfAdGroupsWithDecreasingMobileAdjustments();

    @TranslationStub("Среднее количество групп с корректировками для мобильных устройств")
    Translatable averageNumberOfAdGroupsWithMobileAdjustments();

    @TranslationStub("Среднее количество групп с повышающими корректировками по условиям ретаргетинга и подбора аудитории")
    Translatable averageNumberOfAdGroupsWithIncreasingRetargetingAdjustments();

    @TranslationStub("Среднее количество групп с понижающими корректировками для условий ретаргетинга и подбора аудитории")
    Translatable averageNumberOfAdGroupsWithDecreasingRetargetingAdjustments();

    @TranslationStub("Среднее количество групп с корректировками по условиям ретаргетинга и подбора аудитории")
    Translatable averageNumberOfAdGroupsWithRetargetingAdjustments();

    @TranslationStub("Среднее количество групп с повышающими корректировками по полу и возрасту")
    Translatable averageNumberOfAdGroupsWithIncreasingDemographicsAdjustments();

    @TranslationStub("Среднее количество групп с понижающими корректировками по полу и возрасту")
    Translatable averageNumberOfAdGroupsWithDecreasingDemographicsAdjustments();

    @TranslationStub("Среднее количество групп с корректировками по полу и возрасту")
    Translatable averageNumberOfAdGroupsWithDemographicsAdjustments();

    @TranslationStub("Среднее количество групп с графическими объявлениями")
    Translatable averageNumberOfAdGroupsWithImageAdAds();

    @TranslationStub("Среднее количество групп, в которых есть объявления с широкоформатным изображением")
    Translatable averageNumberOfAdGroupsWithAdsWithWideImage();

    @TranslationStub("Среднее количество групп с автотаргетингом")
    Translatable averageNumberOfAdGroupsWithAutotargeting();

    @TranslationStub("Среднее количество объявлений")
    Translatable averageNumberOfAds();

    @TranslationStub("Среднее количество объявлений в кампаниях \"Текстово-графические объявления\"")
    Translatable averageNumberOfTextAndImageAds();

    @TranslationStub("Среднее количество объявлений в кампаниях \"Динамические объявления\"")
    Translatable averageNumberOfDynamicTextAds();

    @TranslationStub("Среднее количество объявлений в кампаниях \"Реклама мобильных приложений\"")
    Translatable averageNumberOfMobileAppAds();

    @TranslationStub("Среднее количество объявлений в кампаниях \"Текстово-графические объявления\" с показами на поиске")
    Translatable averageNumberOfTextAndImageAdsWithinCampaignsWithEnabledSearch();

    @TranslationStub("Среднее количество объявлений в кампаниях \"Текстово-графические объявления\" с показами в РСЯ")
    Translatable averageNumberOfTextAndImageAdsWithinCampaignsWithEnabledNetwork();

    @TranslationStub("Среднее количество объявлений в кампаниях \"Реклама мобильных приложений\" с показами в РСЯ")
    Translatable averageNumberOfMobileAppAdsWithinCampaignsWithEnabledNetwork();

    @TranslationStub("Среднее количество объявлений с быстрыми ссылками")
    Translatable averageNumberOfAdsWithSitelinks();

    @TranslationStub("Среднее количество объявлений, в которых к быстрым ссылкам добавлено описание")
    Translatable averageNumberOfAdsWithSitelinksWithDescription();

    @TranslationStub("Среднее количество объявлений с изображением")
    Translatable averageNumberOfAdsWithImage();

    @TranslationStub("Среднее количество объявлений с отображаемой ссылкой")
    Translatable averageNumberOfAdsWithDisplayUrl();

    @TranslationStub("Среднее количество объявлений с уточнениями")
    Translatable averageNumberOfAdsWithCallouts();

    @TranslationStub("Среднее количество объявлений с виртуальной визиткой")
    Translatable averageNumberOfAdsWithVCard();

    @TranslationStub("Среднее количество объявлений со вторым заголовком")
    Translatable averageNumberOfAdsWithSecondTitle();

    @TranslationStub("Среднее количество объявлений, отклоненных на модерации")
    Translatable averageNumberOfAdsRejectedOnModeration();

    @TranslationStub("Доля кампаний \"Текстово-графические объявления\"")
    Translatable shareOfTextAndImageAdsCampaigns();

    @TranslationStub("Доля кампаний \"Смарт-баннеры\"")
    Translatable shareOfSmartBannersCampaigns();

    @TranslationStub("Доля кампаний \"Динамические объявления\"")
    Translatable shareOfDynamicAdsCampaigns();

    @TranslationStub("Доля кампаний \"Реклама мобильных приложений\"")
    Translatable shareOfMobileAppAdsCampaigns();

    @TranslationStub("Доля кампаний \"Баннер на поиске\"")
    Translatable shareOfSearchBannerCampaigns();

    @TranslationStub("Доля медийных кампаний")
    Translatable shareOfDisplayCampaigns();

    @TranslationStub("Доля кампаний с показами на поиске")
    Translatable shareOfCampaignsWithSearchEnabled();

    @TranslationStub("Доля кампаний с показами в РСЯ")
    Translatable shareOfCampaignsWithNetworkEnabled();

    @TranslationStub("Доля кампаний с показами на поиске и в РСЯ")
    Translatable shareOfCampaignsWithSearchAndNetworkEnabled();

    @TranslationStub("Доля кампаний с показами только в РСЯ")
    Translatable shareOfCampaignsWithNetworkOnly();

    @TranslationStub("Доля кампаний с автостратегиями")
    Translatable shareOfCampaignsWithAutobudget();

    @TranslationStub("Доля кампаний, в которых указана цель (для CPA/ROI стратегий)")
    Translatable shareOfCampaignsWithGoal();

    @TranslationStub("Доля кампаний, использующих дополнительные релевантные фразы")
    Translatable shareOfCampaignsWithRelevantKeywords();

    @TranslationStub("Доля кампаний с настроенным временным таргетингом")
    Translatable shareOfCampaignsWithTimetarget();

    @TranslationStub("Доля кампаний с указанным счётчиком Метрики")
    Translatable shareOfCampaignsWithMetrika();

    @TranslationStub("Доля кампаний с подключенным Openstat")
    Translatable shareOfCampaignsWithOpenstatEnabled();

    @TranslationStub("Доля групп с десктопными объявлениями")
    Translatable shareOfAdGroupsWithDesktopAds();

    @TranslationStub("Доля групп с мобильными объявлениями")
    Translatable shareOfAdGroupsWithMobileAds();

    @TranslationStub("Доля групп с условиями ретаргетинга и подбора аудитории")
    Translatable shareOfAdGroupsWithRetargetingConditions();

    @TranslationStub("Доля групп с условиями ретаргетинга и подбора аудитории по сегментам Яндекс.Аудиторий")
    Translatable shareOfAdGroupsWithAudienceConditions();

    @TranslationStub("Доля групп с повышающими корректировками для мобильных устройств")
    Translatable shareOfAdGroupsWithIncreasingMobileAdjustments();

    @TranslationStub("Доля групп с понижающими корректировками для мобильных устройств")
    Translatable shareOfAdGroupsWithDecreasingMobileAdjustments();

    @TranslationStub("Доля групп с корректировками для мобильных устройств")
    Translatable shareOfAdGroupsWithMobileAdjustments();

    @TranslationStub("Доля групп с повышающими корректировками по условиям ретаргетинга и подбора аудитории")
    Translatable shareOfAdGroupsWithIncreasingRetargetingAdjustments();

    @TranslationStub("Доля групп с понижающими корректировками по условиям ретаргетинга и подбора аудитории")
    Translatable shareOfAdGroupsWithDecreasingRetargetingAdjustments();

    @TranslationStub("Доля групп с корректировками по условиям ретаргетинга и подбора аудитории")
    Translatable shareOfAdGroupsWithRetargetingAdjustments();

    @TranslationStub("Доля групп с повышающими корректировками по полу и возрасту")
    Translatable shareOfAdGroupsWithIncreasingDemographicsAdjustments();

    @TranslationStub("Доля групп с понижающими корректировками по полу и возрасту")
    Translatable shareOfAdGroupsWithDecreasingDemographicsAdjustments();

    @TranslationStub("Доля групп с корректировками по полу и возрасту")
    Translatable shareOfAdGroupsWithDemographicsAdjustments();

    @TranslationStub("Доля групп с графическими объявлениями")
    Translatable shareOfAdGroupsWithImageAdAds();

    @TranslationStub("Доля групп, в которых есть объявления с широкоформатными изображениями")
    Translatable shareOfAdGroupsWithAdsWithWideImage();

    @TranslationStub("Доля групп с автотаргетингом")
    Translatable shareOfAdGroupsWithAutotargeting();

    @TranslationStub("Доля объявлений с быстрыми ссылками")
    Translatable shareOfAdsWithSitelinks();

    @TranslationStub("Доля объявлений, в которых к быстрым ссылкам добавлено описание")
    Translatable shareOfAdsWithSitelinksWithDescription();

    @TranslationStub("Доля объявлений с изображениями")
    Translatable shareOfAdsWithImage();

    @TranslationStub("Доля объявлений с отображаемой ссылкой")
    Translatable shareOfAdsWithDisplayUrl();

    @TranslationStub("Доля объявлений с уточнениями")
    Translatable shareOfAdsWithCallouts();

    @TranslationStub("Доля объявлений с виртуальными визитками")
    Translatable shareOfAdsWithVCard();

    @TranslationStub("Доля объявлений со вторым заголовком")
    Translatable shareOfAdsWithSecondTitle();

    @TranslationStub("Доля объявлений, отклоненных на модерации")
    Translatable shareOfAdsRejectedOnModeration();

    @TranslationStub("Количество клиентов, активных за период")
    Translatable numberOfClientsActiveDuringPeriod();

    @TranslationStub("Среднее количество клиентов за период")
    Translatable averageNumberOfClientsDuringPeriod();

    @TranslationStub("Доля клиентов с остановками кампаний")
    Translatable shareOfClientsWithStops();

    @TranslationStub("Доля клиентов с общим счетом")
    Translatable shareOfClientsWithWallet();

    @TranslationStub("Среднее количество групп с видеообъявлениями")
    Translatable averageNumberOfAdGroupsWithVideoAds();

    @TranslationStub("Среднее количество объявлений с видеодополнениями")
    Translatable averageNumberOfBannersWithVideoAdditions();

    @TranslationStub("Доля групп с видеообъявлениями")
    Translatable shareOfAdGroupsWithVideoAds();

    @TranslationStub("Доля объявлений с видеодополнениями")
    Translatable shareOfBannersWithVideoAdditions();
}
