package ru.yandex.direct.jobs.agencyofflinereport;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;

/**
 * Переводы заголовков XLS оффлайн-отчета по работе агентств
 */
public interface ReportHeadersTranslations extends TranslationBundle {

    ReportHeadersTranslations INSTANCE = I18NBundle.implement(ReportHeadersTranslations.class);

    @TranslationStub("Отчёт для агентств по клиентам")
    Translatable agencyReportHeader();

    @MessageFormatStub("Агентство: {0} (id: {1})")
    Translatable agencyNameAndId(String agencyName, Long agencyId);

    @MessageFormatStub("За период с {0} по {1}")
    Translatable reportDatesFromTo(String dateFrom, String dateTo);

    @TranslationStub("Расходы приведены без НДС")
    Translatable agencyCurrency();

    @TranslationStub("Среднее по агентству")
    Translatable averageByAgency();
}
