package ru.yandex.direct.jobs.autooverdraft;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.autooverdraftmail.AutoOverdraftMailNotificationType;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.dbutil.model.ClientId;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class AutoOverdraftMailEvent {
    @JsonProperty
    private final AutoOverdraftEventType reason;

    @JsonProperty
    private final AutoOverdraftMailNotificationType notification;

    @JsonProperty
    private final Long clientId;

    @JsonProperty
    private final Long uid;

    @JsonProperty
    private final String templateId;

    @JsonProperty
    private final String errorMessage;

    private AutoOverdraftMailEvent(AutoOverdraftEventType reason, ClientId clientId, User user,
                                   AutoOverdraftMailNotificationType notification, String templateId,
                                   String errorMessage) {
        this.reason = reason;
        this.clientId = clientId.asLong();
        this.uid = user.getUid();
        this.notification = notification;
        this.templateId = templateId;
        this.errorMessage = errorMessage;
    }

    public static AutoOverdraftMailEvent mailSent(AutoOverdraftMailNotificationType notification, ClientId clientId,
                                                  User user, String templateId) {
        return new AutoOverdraftMailEvent(AutoOverdraftEventType.MAIL_SENT, clientId, user, notification,
                templateId,
                null);
    }

    public static AutoOverdraftMailEvent autoOverdraftBadEmail(ClientId clientId, User user, String email) {
        return new AutoOverdraftMailEvent(AutoOverdraftEventType.BAD_EMAIL, clientId, user, null, null, email);
    }

    public static AutoOverdraftMailEvent senderError(AutoOverdraftMailNotificationType notification, ClientId clientId,
                                                     User user, String templateId, String errorMessage) {
        return new AutoOverdraftMailEvent(AutoOverdraftEventType.SENDER_ERROR, clientId, user, notification,
                templateId,
                errorMessage);
    }

    public enum AutoOverdraftEventType {
        BAD_EMAIL,
        MAIL_SENT,
        SENDER_ERROR
    }
}
