package ru.yandex.direct.jobs.autooverdraft;

import java.util.Map;

import ru.yandex.direct.core.entity.autooverdraftmail.AutoOverdraftMailNotificationType;

public class AutoOverdraftMailTemplateResolver {
    private final Map<AutoOverdraftMailNotificationType, String> templateMapping;

    public AutoOverdraftMailTemplateResolver(Map<AutoOverdraftMailNotificationType, String> templateMapping) {
        this.templateMapping =  Map.copyOf(templateMapping);
    }

    public String resolveTemplateId(AutoOverdraftMailNotificationType notification) {
        return templateMapping.get(notification);
    }
}
