package ru.yandex.direct.jobs.autooverdraft;

import ru.yandex.direct.dbutil.model.ClientId;

class OverdraftLimitChangesInfo {
    private final ClientId clientId;
    private final Double overdraftLimit;
    private final String workCurrency;
    private final boolean isNewLimitSmaller;

    OverdraftLimitChangesInfo(ClientId clientId, Double overdraftLimit, String workCurrency,
                              boolean isNewLimitSmaller) {
        this.clientId = clientId;
        this.overdraftLimit = overdraftLimit;
        this.workCurrency = workCurrency;
        this.isNewLimitSmaller = isNewLimitSmaller;
    }

    boolean isNewLimitSmaller() {
        return isNewLimitSmaller;
    }

    ClientId getClientId() {
        return clientId;
    }

    Double getOverdraftLimit() {
        return overdraftLimit;
    }

    String getWorkCurrency() {
        return workCurrency;
    }

    @Override
    public String toString() {
        return "OverdraftLimitChangesInfo{" +
                "clientId=" + clientId +
                ", overdraftLimit=" + overdraftLimit +
                ", workCurrency='" + workCurrency + '\'' +
                ", isNewLimitSmaller=" + isNewLimitSmaller +
                '}';
    }
}
