package ru.yandex.direct.jobs.autooverdraft;

import java.util.List;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.ytwrapper.model.YtField;
import ru.yandex.direct.ytwrapper.model.YtTableRow;

public class OverdraftLimitChangesTableRow extends YtTableRow {
    private static final YtField<Long> CLIENT_ID = new YtField<>("client_id", Long.class);
    private static final YtField<Double> OVERDRAFT_LIMIT = new YtField<>("overdraft_limit", Double.class);
    private static final YtField<Double> OLD_OVERDRAFT_LIMIT = new YtField<>("old_overdraft_limit", Double.class);
    private static final YtField<String> WORK_CURRENCY = new YtField<>("work_currency", String.class);

    public OverdraftLimitChangesTableRow() {
        super(List.of(CLIENT_ID, OVERDRAFT_LIMIT, OLD_OVERDRAFT_LIMIT, WORK_CURRENCY));
    }

    public ClientId getClientId() {
        return ClientId.fromLong(valueOf(CLIENT_ID));
    }

    public Double getOverdraftLimit() {
        return valueOf(OVERDRAFT_LIMIT);
    }

    public boolean isNewLimitSmaller() {
        return valueOf(OVERDRAFT_LIMIT) < valueOf(OLD_OVERDRAFT_LIMIT);
    }

    public String getWorkCurrency() {
        return valueOf(WORK_CURRENCY);
    }
}
