package ru.yandex.direct.jobs.balance.productsimport;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.product.model.Product;
import ru.yandex.direct.core.entity.product.model.ProductCalcType;
import ru.yandex.direct.core.entity.product.model.ProductType;
import ru.yandex.direct.core.entity.product.model.ProductUnit;
import ru.yandex.direct.currency.CurrencyCode;

import static ru.yandex.direct.utils.CommonUtils.nvl;

@Component
public class ProductTableRowConsumer implements Consumer<ProductsTableRow> {

    static final Long DIRECT_ENGINE_ID = 7L;
    private static final BigDecimal DEFAULT_PRICE = BigDecimal.ONE;
    private static final String DEFAULT_UNIT_NAME = "Bucks";
    private static final Long DEFAULT_RATE = 1L;
    private int readCount = 0;

    private final List<Product> products = new ArrayList<>();

    @Override
    public void accept(ProductsTableRow productTableRow) {
        readCount++;
        if (!DIRECT_ENGINE_ID.equals(productTableRow.getEngineId())) {
            return;
        }

        products.add(
                new Product()
                        .withId(productTableRow.getId())
                        .withThemeId(0L)
                        .withPrice(DEFAULT_PRICE)
                        .withUnitName(DEFAULT_UNIT_NAME)
                        .withUnit(ProductUnit.SHOWS)
                        .withBusinessUnit(null)
                        .withRate(DEFAULT_RATE)
                        .withType(ProductType.AUTO_IMPORT)
                        .withEngineId(DIRECT_ENGINE_ID)
                        .withCalcType(ProductCalcType.CPM)
                        .withUnitScale(1L)
                        .withPublicNameKey("")
                        .withPublicDescriptionKey("")
                        .withProductName(productTableRow.getName())
                        .withCurrencyCode(CurrencyCode.valueOf(nvl(productTableRow.getCurrency(), "RUB").toUpperCase()))
        );
    }

    public int getReadCount() {
        return readCount;
    }

    public List<Product> getProducts() {
        return products;
    }

    public void clear() {
        readCount = 0;
        products.clear();
    }
}
