package ru.yandex.direct.jobs.balance.productsimport;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import com.google.common.collect.ImmutableList;

import ru.yandex.direct.ytwrapper.model.YtField;
import ru.yandex.direct.ytwrapper.model.YtTableRow;

public class ProductsTableRow extends YtTableRow {
    public static final YtField<String> NAME = new YtField<>("name", String.class);
    public static final YtField<Long> ID = new YtField<>("id", Long.class);
    public static final YtField<String> ISO_CURRENCY = new YtField<>("reference_price_iso_currency", String.class);
    public static final YtField<String> UNIT = new YtField<>("product_type_cc", String.class);
    public static final YtField<Long> ENGINE_ID = new YtField<>("engine_id", Long.class);

    public ProductsTableRow() {
        this(Collections.emptyList());
    }

    public ProductsTableRow(Collection<YtField> fields) {
        super(ImmutableList.<YtField>builder()
                .addAll(Arrays.asList(ID, ENGINE_ID, NAME, UNIT, ISO_CURRENCY))
                .addAll(fields)
                .build());
    }

    public Long getId() {
        return valueOf(ID);
    }

    public void setId(Long id) {
        setValue(ID, id);
    }

    public String getName() {
        return valueOf(NAME);
    }

    public void setName(String name) {
        setValue(NAME, name);
    }

    public Long getEngineId() {
        return valueOf(ENGINE_ID);
    }

    public void setEngineId(Long engineId) {
        setValue(ENGINE_ID, engineId);
    }

    public String getUnit() {
        return valueOf(UNIT);
    }

    public void setUnit(String unit) {
        setValue(UNIT, unit);
    }


    public String getCurrency() {
        return valueOf(ISO_CURRENCY);
    }

    public void setCurrency(String currency) {
        setValue(ISO_CURRENCY, currency);
    }
}
