package ru.yandex.direct.jobs.balanceaggrmigration.monitoring.model;

public class ClientStat {
    private long totalClients;
    private long billingAggregateClients;

    public ClientStat(long totalClients, long billingAggregateClients) {
        this.totalClients = totalClients;
        this.billingAggregateClients = billingAggregateClients;
    }

    public ClientStat add(ClientStat newStat) {
        return new ClientStat(totalClients + newStat.totalClients,
                billingAggregateClients + newStat.billingAggregateClients);
    }

    public long getTotalClients() {
        return totalClients;
    }

    public long getBillingAggregateClients() {
        return billingAggregateClients;
    }
}
