package ru.yandex.direct.jobs.banner.service;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import com.google.common.collect.Lists;
import one.util.streamex.StreamEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.model.BannerWithAggregatorDomain;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.repository.BannerTypedRepository;
import ru.yandex.direct.core.entity.banner.type.href.BannerDomainRepository;
import ru.yandex.direct.core.entity.bs.resync.queue.model.BsResyncItem;
import ru.yandex.direct.core.entity.bs.resync.queue.service.BsResyncService;
import ru.yandex.direct.core.entity.domain.service.AggregatorDomainsService;
import ru.yandex.direct.dbutil.SqlUtils;

import static ru.yandex.direct.core.entity.bs.resync.queue.model.BsResyncPriority.SYNC_AGGREGATOR_DOMAINS;
import static ru.yandex.direct.utils.FunctionalUtils.selectList;

@Service
public class BannerUpdateAggeregatorDomainService {
    private static final Logger logger = LoggerFactory.getLogger(BannerUpdateAggeregatorDomainService.class);

    private final AggregatorDomainsService aggregatorDomainsService;
    private final BsResyncService bsResyncService;
    private final BannerDomainRepository bannerDomainRepository;
    private final BannerTypedRepository bannerTypedRepository;

    @Autowired
    public BannerUpdateAggeregatorDomainService(AggregatorDomainsService aggregatorDomainsService,
                                                BsResyncService bsResyncService,
                                                BannerDomainRepository bannerDomainRepository,
                                                BannerTypedRepository bannerTypedRepository) {
        this.aggregatorDomainsService = aggregatorDomainsService;
        this.bsResyncService = bsResyncService;
        this.bannerDomainRepository = bannerDomainRepository;
        this.bannerTypedRepository = bannerTypedRepository;
    }

    public void updateAggregatorDomains(int shard, String domain) {
        Set<Long> bannerIds = bannerDomainRepository.getBannerIdsByDomain(shard, domain);
        List<Banner> untypedBanners = bannerTypedRepository.getTyped(shard, bannerIds);
        List<BannerWithAggregatorDomain> banners = selectList(untypedBanners, BannerWithAggregatorDomain.class);

        logger.info("{} banners found in shard {}", banners.size(), shard);
        for (List<BannerWithAggregatorDomain> bannerList :
                Lists.partition(banners, SqlUtils.TYPICAL_SELECT_CHUNK_SIZE)) {
            aggregatorDomainsService.updateAggregatorDomains(shard, bannerList);
            Collection<BsResyncItem> bsResyncItems = StreamEx.of(bannerList)
                    .map(BannerWithSystemFields.class::cast)
                    .map(b -> new BsResyncItem(SYNC_AGGREGATOR_DOMAINS,
                            b.getCampaignId(), b.getId(), null))
                    .toList();
            bsResyncService.addObjectsToResync(bsResyncItems);
        }
    }
}
