package ru.yandex.direct.jobs.bannersystem;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.core.entity.bs.export.queue.service.FullExportQueueService;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.support.DirectShardedJob;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_2;
import static ru.yandex.direct.juggler.check.model.CheckTag.GROUP_INTERNAL_SYSTEMS;
import static ru.yandex.direct.juggler.check.model.NotificationRecipient.CHAT_INTERNAL_SYSTEMS_MONITORING;


/**
 * Мастер-процесс переотправки Директа в БК (YABS-CS) через LogBroker.
 * Добавляет в очередь экспорта в БК кампаниям признак "требуется полная переотправка" (is_full_export).
 * Граничные условия (сколько добавлять, в каких условиях) - управляются через ppc_properties и внутренний отчет.
 * <p>
 * Оптимизирован на пропускную способность/поддержание очереди наполненной.
 */
@Hourglass(periodInSeconds = 2 * 60, needSchedule = ProductionOnly.class)
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 17),
        needCheck = ProductionOnly.class,
        notifications = {
                @OnChangeNotification(recipient = CHAT_INTERNAL_SYSTEMS_MONITORING,
                        status = {JugglerStatus.OK, JugglerStatus.CRIT},
                        method = NotificationMethod.TELEGRAM),
        },
        tags = {DIRECT_PRIORITY_2, GROUP_INTERNAL_SYSTEMS}
)
@ParametersAreNonnullByDefault
public class FullExportMasterProcess extends DirectShardedJob {
    private final FullExportQueueService service;

    @Autowired
    public FullExportMasterProcess(FullExportQueueService service) {
        this.service = service;
    }

    FullExportMasterProcess(int shard, FullExportQueueService service) {
        super(shard);
        this.service = service;
    }

    @Override
    public void execute() {
        service.getMaster(getShard()).iteration();
    }
}
