package ru.yandex.direct.jobs.bannersystem.dataimport;

import java.util.List;

import ru.yandex.direct.ytwrapper.model.YtField;
import ru.yandex.direct.ytwrapper.model.YtTableRow;

class PageTableRow extends YtTableRow {
    private static final YtField<Long> PAGE_ID = new YtField<>("PageID", Long.class);
    private static final YtField<Long> ORIG_PAGE_ID = new YtField<>("OrigPageID", Long.class);
    private static final YtField<String> NAME = new YtField<>("Name", String.class);
    private static final YtField<String> DESCRIPTION = new YtField<>("Description", String.class);
    private static final YtField<Long> TARGET_TYPE = new YtField<>("TargetType", Long.class);
    private static final YtField<Boolean> OPTIONS_YANDEX_GROUP = new YtField<>("OptionsYandexGroup", Boolean.class);
    private static final YtField<Boolean> OPTIONS_YANDEX_PAGE = new YtField<>("OptionsYandexPage", Boolean.class);
    private static final YtField<Boolean> OPTIONS_DISTRIB_ADV = new YtField<>("OptionsDistribAdv", Boolean.class);

    PageTableRow() {
        super(List.of(PAGE_ID, ORIG_PAGE_ID, NAME, DESCRIPTION, TARGET_TYPE, OPTIONS_YANDEX_GROUP,
                OPTIONS_YANDEX_PAGE, OPTIONS_DISTRIB_ADV));
    }

    Long getPageId() {
        return valueOf(PAGE_ID);
    }

    Long getOrigPageId() {
        return valueOf(ORIG_PAGE_ID);
    }

    String getName() {
        return valueOf(NAME);
    }

    String getDescription() {
        return valueOf(DESCRIPTION);
    }

    Long getTargetType() {
        return valueOf(TARGET_TYPE);
    }

    Boolean getOptYaGroup() {
        return valueOf(OPTIONS_YANDEX_GROUP);
    }

    Boolean getOptYaPage() {
        return valueOf(OPTIONS_YANDEX_PAGE);
    }

    Boolean getOptDistribAdv() {
        return valueOf(OPTIONS_DISTRIB_ADV);
    }
}
