package ru.yandex.direct.jobs.bannersystem.export.container;

/**
 * Объект, хранящий в себе метрики итерации синхронизации мобильного контента с БК
 */
public class MobileContentExportIndicators {
    private int itemsSent = 0;
    private int itemsReceived = 0;
    private int itemsError = 0;
    private int itemsSynced = 0;

    public int getItemsSent() {
        return itemsSent;
    }

    public void addItemsSent(int itemsSent) {
        this.itemsSent += itemsSent;
    }

    public int getItemsReceived() {
        return itemsReceived;
    }

    public void addItemsReceived(int itemsReceived) {
        this.itemsReceived += itemsReceived;
    }

    public int getItemsError() {
        return itemsError;
    }

    public void addItemsError(int itemsError) {
        this.itemsError += itemsError;
    }

    public int getItemsSynced() {
        return itemsSynced;
    }

    public void addItemsSynced(int itemsSynced) {
        this.itemsSynced += itemsSynced;
    }

    public void addIndicators(MobileContentExportIndicators indicators) {
        addItemsSent(indicators.itemsSent);
        addItemsReceived(indicators.itemsReceived);
        addItemsError(indicators.itemsError);
        addItemsSynced(indicators.itemsSynced);
    }
}
