package ru.yandex.direct.jobs.bannersystem.export.util;

import ru.yandex.direct.core.entity.mobilecontent.model.AgeLabel;
import ru.yandex.direct.core.entity.mobilecontent.model.OsType;

/**
 * Небольшие методы-хелперы, специфичные для экспорта мобильного контента в БК
 */
public class BsExportMobileContentUtil {
    private BsExportMobileContentUtil() {
    }

    /**
     * Получить текстовое значение типа OS для енама
     * TODO(bzzzz): надо бы научить генератор моделей подтягивать эти значения для енама и убрать метод
     */
    public static String getOsTypeStringRepresentation(OsType osType) {
        if (osType == OsType.IOS) {
            return "iOS";
        } else if (osType == OsType.ANDROID) {
            return "Android";
        }

        throw new IllegalStateException(String.format("Unknown os type %s", osType));
    }

    /**
     * Получить числовое значение возрастного ограничения для енама
     * TODO(bzzzz): надо бы научить генератор моделей подтягивать эти значения для енама и убрать метод
     */
    public static String getAgeLabelRepresentation(AgeLabel ageLabel) {
        if (ageLabel == AgeLabel._0_2B) {
            return "0";
        } else if (ageLabel == AgeLabel._6_2B) {
            return "6";
        } else if (ageLabel == AgeLabel._12_2B) {
            return "12";
        } else if (ageLabel == AgeLabel._16_2B) {
            return "16";
        } else if (ageLabel == AgeLabel._18_2B) {
            return "18";
        }

        throw new IllegalStateException(String.format("Unknown age label %s", ageLabel));
    }
}
