package ru.yandex.direct.jobs.bannersystem.export.util;

import ru.yandex.direct.currency.Currencies;
import ru.yandex.direct.currency.CurrencyCode;

/**
 * Небольшие методы-хелперы, специфичные для всего экспорта в БК
 */
public class BsExportUtil {
    private static final int BS_YND_ISO_CURRENCY_CODE = -1;

    private BsExportUtil() {
    }

    /**
     * Получить номерной ISO-код валюты по ее названию. Для фишек возвращает -1
     *
     * @param code код валюты
     */
    public static int getBsIsoCurrencyCode(CurrencyCode code) {
        if (code == CurrencyCode.YND_FIXED) {
            return BS_YND_ISO_CURRENCY_CODE;
        }
        return Currencies.getCurrency(code).getIsoNumCode();
    }
}
