package ru.yandex.direct.jobs.bannersystem.logs.configuration;

import java.util.List;

import ru.yandex.direct.ess.common.logbroker.LogbrokerConsumerProperties;

import static com.google.common.base.Preconditions.checkState;

public class BsExportLogsLogbrokerConsumerProperties implements LogbrokerConsumerProperties {

    private static final String TOPIC = "direct/direct-banners-log";
    private static final long INIT_TIMEOUT = 30;
    private final String consumer;

    private final String logbrokerHost;
    private final long readDataTimeout;
    private final int retries;
    private final List<Integer> groups;
    private final int maxCount;
    private final Integer maxSize;

    private BsExportLogsLogbrokerConsumerProperties(Builder builder) {
        this.logbrokerHost = builder.logbrokerHost;
        this.consumer = builder.consumer;
        this.readDataTimeout = builder.readDataTimeout;
        this.retries = builder.retries;
        this.groups = List.copyOf(builder.groups);
        this.maxCount = builder.maxCount;
        this.maxSize = builder.maxSize;
    }

    @Override
    public String getHost() {
        return logbrokerHost;
    }

    @Override
    public long getReadDataTimeoutSec() {
        return readDataTimeout;
    }

    @Override
    public String getReadTopic() {
        return TOPIC;
    }

    @Override
    public String getConsumerName() {
        return consumer;
    }

    @Override
    public List<Integer> getGroups() {
        return groups;
    }

    @Override
    public long getInitTimeoutSec() {
        return INIT_TIMEOUT;
    }

    @Override
    public int getRetries() {
        return retries;
    }

    @Override
    public int getReadBufferSize() {
        return 135;
    }

    @Override
    public int getMaxCount() {
        return maxCount;
    }

    @Override
    public Integer getMaxSize() {
        return maxSize;
    }

    @Override
    public Integer getMaxUnconsumedReads() {
        return 42;
    }

    public static Builder toDynTableFromTesting() {
        Builder builder = new Builder();
        builder.logbrokerHost = "lbkxt.logbroker.yandex.net";
        builder.groups = List.of();
        builder.readDataTimeout = 4;
        builder.retries = 3;
        builder.maxSize = null;
        builder.maxCount = 50;
        return builder;
    }

    public static Builder toStaticTablesFromProd() {
        Builder builder = new Builder();
        builder.logbrokerHost = "lbkx.logbroker.yandex.net";
        builder.readDataTimeout = 10;
        builder.retries = 1;
        builder.maxSize = 1024*1024*2;
        builder.maxCount = 200;
        return builder;
    }

    public static class Builder {
        private String consumer;
        private String logbrokerHost;
        private long readDataTimeout;
        private int retries;
        private List<Integer> groups;
        private int maxCount;
        private Integer maxSize;


        private Builder() {
        }

        public Builder setConsumer(String consumer) {
            this.consumer = consumer;
            return this;
        }

        public Builder setGroups(List<Integer> groups) {
            this.groups = groups;
            return this;
        }

        public BsExportLogsLogbrokerConsumerProperties build() {
            checkState(consumer != null, "forgotten consumer");
            checkState(logbrokerHost != null, "forgotten logbrokerHost");
            checkState(readDataTimeout > 0, "readDataTimeout should be greater than 0");
            checkState(retries > 0, "retries should be greater than 0");
            checkState(groups != null, "groups is mandatory");
            return new BsExportLogsLogbrokerConsumerProperties(this);
        }
    }
}
