package ru.yandex.direct.jobs.bannersystem.logs.model;

import javax.annotation.Nullable;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.direct.utils.JsonUtils;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

public class BsExportLogsEntry {

    private final String uuid;
    private final Long cid;
    private final Long pid;
    private final String level;
    private final String dataString;
    private final Integer dataHash;

    public BsExportLogsEntry(JsonNode data) throws JsonProcessingException {
        this.uuid = data.get("uuid").asText();
        this.cid = data.get("cid").asLong();
        this.pid = data.hasNonNull("pid") ? data.get("pid").asLong() : 0L;
        this.level = data.get("level").asText();
        this.dataString = JsonUtils.getObjectMapper().writeValueAsString(data);
        this.dataHash = dataString.hashCode();
    }

    @Nullable
    public YTreeMapNode buildYTreeMapNode() {
        return YTree.mapBuilder()
                .key("uuid").value(uuid)
                .key("cid").value(cid)
                .key("pid").value(pid)
                .key("type").value(level)
                .key("data").value(dataString)
                .key("dataHash").value(dataHash)
                .buildMap();
    }
}
