package ru.yandex.direct.jobs.bannersystem.logs.reader;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.binlogbroker.logbroker_utils.reader.impl.LogbrokerBatchReaderImpl;
import ru.yandex.direct.jobs.bannersystem.logs.model.BsExportLogsEntry;
import ru.yandex.direct.utils.JsonUtils;
import ru.yandex.kikimr.persqueue.consumer.SyncConsumer;
import ru.yandex.kikimr.persqueue.consumer.transport.message.inbound.data.MessageBatch;
import ru.yandex.kikimr.persqueue.consumer.transport.message.inbound.data.MessageData;

public class BsExportLogsLogbrokerReader extends LogbrokerBatchReaderImpl<BsExportLogsEntry> {

    private static final Logger logger = LoggerFactory.getLogger(BsExportLogsLogbrokerReader.class);

    public BsExportLogsLogbrokerReader(Supplier<SyncConsumer> logbrokerConsumerSupplier) {
        super(logbrokerConsumerSupplier, false);
        this.iterationTime = Duration.ofSeconds(1);
    }

    @Override
    protected List<BsExportLogsEntry> batchDeserialize(MessageBatch messageBatch) {

        List<BsExportLogsEntry> result = new ArrayList<>();

        for (MessageData messageData : messageBatch.getMessageData()) {
            byte[] bytes = messageData.getDecompressedData();
            String dataString = new String(bytes);

            ObjectMapper objectMapper = JsonUtils.getObjectMapper();
            try {
                JsonNode jsonNode = objectMapper.readTree(bytes);

                for (JsonNode element : jsonNode) {
                    BsExportLogsEntry logsEntry = new BsExportLogsEntry(element);
                    result.add(logsEntry);
                }

            } catch (IOException | NullPointerException e) {
                logger.error("Got {} while parsing data: {}", e.getMessage(), dataString);
            }
        }
        return result;
    }

    @Override
    protected int count(List<BsExportLogsEntry> e) {
        return e.size();
    }
}
