package ru.yandex.direct.jobs.blackbox.check;

import java.time.Duration;
import java.util.List;

import ru.yandex.direct.juggler.JugglerEvent;
import ru.yandex.direct.juggler.check.DirectNumericCheck;

public class AudienceRobotPasswordRemainsCheck extends DirectNumericCheck {
    private static final String CHECK_NAME_TEMPLATE = "password.expire_time.yndx-robot-direct-aud";

    AudienceRobotPasswordRemainsCheck(String host, Duration warnBorder, Duration critBorder) {
        super(
                CHECK_NAME_TEMPLATE,
                warnBorder.toDays(),
                critBorder.toDays(),
                host,
                "Остаток дней пароля робота до протухания",
                false
        );
    }

    @Override
    public List<String> getRawServiceNames() {
        return List.of(CHECK_NAME_TEMPLATE);
    }

    public JugglerEvent generateEvent(Long value) {
        return getEvent(value, CHECK_NAME_TEMPLATE, null);
    }
}
