package ru.yandex.direct.jobs.blackbox.check;

import java.time.Duration;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.juggler.JugglerEvent;
import ru.yandex.direct.juggler.check.DirectNumericCheck;
import ru.yandex.direct.juggler.check.DirectNumericChecksBundle;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.juggler.check.model.NotificationRecipient;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_2;

@JugglerCheck(ttl = @JugglerCheck.Duration(days = 2, hours = 2),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_2},
        notifications = @OnChangeNotification(
                recipient = NotificationRecipient.CHAT_INTERNAL_SYSTEMS_MONITORING,
                method = NotificationMethod.TELEGRAM
        )
)
public class AudienceRobotPasswordRemainsCheckBundle implements DirectNumericChecksBundle {

    private static final Duration WARN_BORDER = Duration.ofDays(12L);
    private static final Duration CRIT_BORDER = Duration.ofDays(5L);

    private final AudienceRobotPasswordRemainsCheck check;

    @Autowired
    public AudienceRobotPasswordRemainsCheckBundle(@Value("${juggler.checks.target_host}") String host) {
        check = new AudienceRobotPasswordRemainsCheck(host, WARN_BORDER, CRIT_BORDER);
    }

    @Override
    public List<DirectNumericCheck> getBundledChecks() {
        return List.of(check);
    }

    public JugglerEvent generateEvent(Long value) {
        return check.generateEvent(value);
    }

}
