package ru.yandex.direct.jobs.brandliftconditions;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.ytwrapper.YtPathUtil;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.direct.ytwrapper.model.YtTable;
import ru.yandex.direct.ytwrapper.utils.FreshestClusterFinder;

import static ru.yandex.direct.jobs.util.yt.YtEnvPath.relativePart;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
@Component
public class YtHelper {
    private final YtProvider ytProvider;
    private final DirectConfig brandLiftConfig;

    public YtHelper(YtProvider ytProvider, DirectConfig directConfig) {
        this.ytProvider = ytProvider;
        this.brandLiftConfig = directConfig.getBranch("brand_lift");
    }

    public YtTable getBudgetEstimationsTable(YtCluster ytCluster) {
        var ytClusterConfig = ytProvider.getClusterConfig(ytCluster);
        var budgetEstimationsPath = brandLiftConfig.getBranch("yt").getString("budget_estimations_table_partial_path");
        return new YtTable(YtPathUtil.generatePath(ytClusterConfig.getHome(), relativePart(), budgetEstimationsPath));
    }

    public YtTable getBudgetEstimationsShardedTable(YtCluster ytCluster, int shardId) {
        var ytClusterConfig = ytProvider.getClusterConfig(ytCluster);
        var budgetEstimationsPath = brandLiftConfig.getBranch("yt").getString("budget_estimations_table_partial_path");
        return new YtTable(YtPathUtil.generatePath(
                ytClusterConfig.getHome(),
                relativePart(),
                budgetEstimationsPath + "_" + shardId));
    }

    public String getPool(YtCluster ytCluster) {
        var ytPool = brandLiftConfig.getBranch("yt").getString("yt_pool");
        if (ytPool.isEmpty()) {
            ytPool = ytProvider.getClusterConfig(ytCluster).getUser();
        }
        return ytPool;
    }

    public YtCluster chooseFreshestCluster() {
        var campaignsTablePath = brandLiftConfig.getBranch("yt").getString("mysql_sync_states_table_path");
        var clustersList = brandLiftConfig.getBranch("yt").getStringList("clusters");
        var ytClusters = mapList(clustersList, s -> YtCluster.valueOf(s.toUpperCase()));
        return FreshestClusterFinder.getFreshestCluster(ytProvider, new YtTable(campaignsTablePath), ytClusters);
    }
}
