package ru.yandex.direct.jobs.brandliftconditions.budgetestimation;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

import javax.annotation.ParametersAreNonnullByDefault;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class BudgetEstimationsDailyConsumer implements Consumer<BudgetEstimationsTableRow> {

    private static final Logger logger = LoggerFactory.getLogger(BudgetEstimationsDailyConsumer.class);

    private final List<BudgetEstimation> budgetEstimations;

    public BudgetEstimationsDailyConsumer() {
        this.budgetEstimations = new ArrayList<>();
    }

    @Override
    public void accept(BudgetEstimationsTableRow ytTableRow) {
        Double sumSpentByDay = ytTableRow.getSumSpentByDay();
        if (sumSpentByDay == null) {
            logger.warn("Found budget_estimations.sum_spent_by_day with null value");
            sumSpentByDay = 0d;
        }

        Double sumEstimatedByDay = ytTableRow.getSumEstimatedByDay();
        if (sumEstimatedByDay == null) {
            logger.warn("Found budget_estimations.sum_estimated_by_day with null value");
            sumEstimatedByDay = 0d;
        }

        Double sumSpent = ytTableRow.getSumSpent();
        if (sumSpent == null) {
            logger.warn("Found budget_estimations.sum_spent with null value");
            sumSpent = 0d;
        }

        var budgetEstimation = new BudgetEstimation(
                ytTableRow.getCid(),
                sumSpentByDay,
                sumEstimatedByDay,
                sumSpent,
                ytTableRow.getCurrencyRate(),
                ytTableRow.getCurrency());

        budgetEstimations.add(budgetEstimation);
    }

    public List<BudgetEstimation> getData() {
        return budgetEstimations;
    }

    public void clear() {
        budgetEstimations.clear();
    }
}
