package ru.yandex.direct.jobs.brandliftconditions.budgetestimation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableList;

import ru.yandex.direct.ytwrapper.model.YtField;
import ru.yandex.direct.ytwrapper.model.YtTableRow;

@ParametersAreNonnullByDefault
public class BudgetEstimationsTableRow extends YtTableRow {

    public static final YtField<Long> CID = new YtField<>("cid", Long.class);
    public static final YtField<Double> CURRENCY_RATE = new YtField<>("currency_rate", Double.class);
    public static final YtField<String> CURRENCY = new YtField<>("currency", String.class);
    public static final YtField<Double> SUM_SPENT_BY_DAY = new YtField<>("sum_spent_by_day", Double.class);
    public static final YtField<Double> SUM_ESTIMATED_BY_DAY = new YtField<>("sum_estimated_by_day", Double.class);
    public static final YtField<Double> SUM_SPENT = new YtField<>("sum_spent", Double.class);

    public BudgetEstimationsTableRow() {
        this(Collections.emptyList());
    }

    public BudgetEstimationsTableRow(Collection<YtField> fields) {
        super(ImmutableList.<YtField>builder()
                .addAll(Arrays.asList(CID, CURRENCY_RATE, CURRENCY, SUM_SPENT_BY_DAY, SUM_ESTIMATED_BY_DAY, SUM_SPENT))
                .addAll(fields)
                .build());
    }

    public Long getCid() {
        return valueOf(CID);
    }

    public void setCid(Long cid) {
        setValue(CID, cid);
    }

    public Double getCurrencyRate() {
        return valueOf(CURRENCY_RATE);
    }

    public void setCurrencyRate(Double currencyRate) {
        setValue(CURRENCY_RATE, currencyRate);
    }

    public String getCurrency() {
        return valueOf(CURRENCY);
    }

    public void setCurrency(String currency) {
        setValue(CURRENCY, currency);
    }

    public Double getSumSpentByDay() {
        return valueOf(SUM_SPENT_BY_DAY);
    }

    public void setSumEstimatedByDay(Double sumEstimatedByDayRub) {
        setValue(SUM_ESTIMATED_BY_DAY, sumEstimatedByDayRub);
    }

    public Double getSumEstimatedByDay() {
        return valueOf(SUM_ESTIMATED_BY_DAY);
    }

    public void setSumSpentByDay(Double sumSpentByDayRub) {
        setValue(SUM_SPENT_BY_DAY, sumSpentByDayRub);
    }

    public Double getSumSpent() {
        return valueOf(SUM_SPENT);
    }

    public void setSumSpent(Double sumSpent) {
        setValue(SUM_SPENT, sumSpent);
    }
}
