package ru.yandex.direct.jobs.bsexport;

import java.util.List;

import ru.yandex.direct.core.entity.bs.export.model.WorkerSpec;
import ru.yandex.direct.scheduler.support.ParametersSource;

public class BsExportWorkerParametersSource implements ParametersSource<BsExportWorkerParam> {

    private List<BsExportWorkerParam> params;

    private static final String SEPARATOR = ":";

    public BsExportWorkerParametersSource(List<BsExportWorkerParam> params) {
        this.params = params;
    }

    @Override
    public List<BsExportWorkerParam> getAllParamValues() {
        return params;
    }

    @Override
    public BsExportWorkerParam convertStringToParam(String string) {
        var parts = string.split(SEPARATOR);

        return new BsExportWorkerParam(WorkerSpec.valueOf(parts[0]), Integer.parseInt(parts[1]));
    }

    @Override
    public String convertParamToString(BsExportWorkerParam paramValue) {
        return paramValue.getWorkerSpec() + SEPARATOR + paramValue.getShard();
    }
}
