package ru.yandex.direct.jobs.calltracking;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcPropertyNames;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.jobs.yt.ExecuteYQLAndExportDataJob;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.juggler.check.model.CheckTag;
import ru.yandex.direct.juggler.check.model.NotificationRecipient;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.ytwrapper.client.YtProvider;

import static ru.yandex.direct.jobs.calltracking.CalltrackingJobUtils.CALLTRACKING_CONFIG_BRANCH;
import static ru.yandex.direct.jobs.calltracking.CalltrackingJobUtils.PARSED_LOG_FOLDER;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_1_NOT_READY;

/**
 * Запускает yql-запрос, который извлекает из bs-watch-log (данные за день) данные о кликах по ссылкам tel: ...
 * и пишет их в статическую таблицу, все строчки которой потом будут записаны в общую дин таблицу
 * джобой {@link PopulateCalltrackingDynTableJob}
 * Insert данных в статическую таблицу происходит прямо в yql-запросе {@code calltracking/CalltrackingParseWatchLog.sql}
 */
@JugglerCheck(
        ttl = @JugglerCheck.Duration(hours = 9),
        needCheck = ProductionOnly.class,
        //PRIORITY: Временно поставили приоритет по умолчанию;
        tags = {DIRECT_PRIORITY_1_NOT_READY, CheckTag.DIRECT_CALLTRACKING},
        notifications = @OnChangeNotification(
                recipient = {NotificationRecipient.CHAT_API_CLEAN_MONITORING},
                method = NotificationMethod.TELEGRAM,
                status = {JugglerStatus.OK, JugglerStatus.CRIT}
        )
)
@Hourglass(cronExpression = "0 0 */6 * * ?", needSchedule = ProductionOnly.class)
public class ParseWatchLogsCalltrackingJob extends ExecuteYQLAndExportDataJob {
    @Autowired
    public ParseWatchLogsCalltrackingJob(
            DirectConfig directConfig,
            YtProvider ytProvider,
            PpcPropertiesSupport ppcPropertiesSupport
    ) {
        super(
                directConfig,
                ytProvider,
                ppcPropertiesSupport.get(PpcPropertyNames.PARSE_WATCH_LOG_CLUSTER),
                ppcPropertiesSupport.get(PpcPropertyNames.CALLTRACKING_PARSE_WATCH_LOG_LAST_READ_TIME),
                "calltracking/CalltrackingParseWatchLog.sql"
        );
    }

    @Override
    protected List<String> getSourceTablesPathTemplate() {
        return List.of("//logs/bs-watch-log/1d/%s");
    }

    @Override
    protected String getConfigBranch() {
        return CALLTRACKING_CONFIG_BRANCH;
    }

    @Override
    protected String getOutputTablesFolder() {
        return PARSED_LOG_FOLDER;
    }
}
