package ru.yandex.direct.jobs.calltracking

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames
import ru.yandex.direct.config.DirectConfig
import ru.yandex.direct.env.ProductionOnly
import ru.yandex.direct.jobs.calltracking.CalltrackingJobUtils.PARSED_LOG_FOLDER
import ru.yandex.direct.jobs.yt.ExecuteYQLAndExportDataJob
import ru.yandex.direct.juggler.JugglerStatus
import ru.yandex.direct.juggler.check.annotation.JugglerCheck
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification
import ru.yandex.direct.juggler.check.model.CheckTag
import ru.yandex.direct.juggler.check.model.NotificationRecipient
import ru.yandex.direct.scheduler.Hourglass
import ru.yandex.direct.ytwrapper.client.YtProvider

/**
 * Запускает yql-запрос, который извлекает из bs-watch-log (данные за день) данные о сторонних коллтрекингах,
 * найденных на сайтах рекламодателей
 * и пишет их в статическую таблицу, все строчки которой потом будут записаны в общую дин таблицу
 * джобой [PopulateExternalCalltrackingByDomainDynTableJob]
 * Insert данных в статическую таблицу происходит прямо в yql-запросе
 * `ExternalCalltrackingParseWatchLog.sql`
 */
@JugglerCheck(
    ttl = JugglerCheck.Duration(hours = 9),
    needCheck = ProductionOnly::class,
    tags = [CheckTag.DIRECT_PRIORITY_1_NOT_READY, CheckTag.DIRECT_CALLTRACKING],
    notifications = [
        OnChangeNotification(
            recipient = [NotificationRecipient.CHAT_API_CLEAN_MONITORING],
            method = [NotificationMethod.TELEGRAM],
            status = [JugglerStatus.OK, JugglerStatus.CRIT]
        )
    ]
)
@Hourglass(cronExpression = "0 0 */6 * * ?", needSchedule = ProductionOnly::class)
class ParseWatchLogsExternalCalltrackingByDomainJob(
    directConfig: DirectConfig,
    ytProvider: YtProvider,
    ppcPropertiesSupport: PpcPropertiesSupport
) : ExecuteYQLAndExportDataJob(
    directConfig,
    ytProvider,
    ppcPropertiesSupport.get(PpcPropertyNames.PARSE_WATCH_LOG_CLUSTER),
    ppcPropertiesSupport.get(PpcPropertyNames.CALLTRACKING_EXTERNAL_BY_DOMAIN_PARSE_WATCH_LOG_LAST_READ_TIME),
    "calltracking/ExternalCalltrackingParseWatchLog.sql"
) {
    override fun getSourceTablesPathTemplate() = listOf("//logs/bs-watch-log/1d/%s")

    override fun getConfigBranch() = CalltrackingJobUtils.EXTERNAL_CALLTRACKING_CONFIG_BRANCH

    override fun getOutputTablesFolder() = PARSED_LOG_FOLDER
}
