package ru.yandex.direct.jobs.calltracking;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcPropertyNames;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.jobs.yt.PopulateDynTableJob;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.juggler.check.model.CheckTag;
import ru.yandex.direct.juggler.check.model.NotificationRecipient;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

import static ru.yandex.direct.jobs.calltracking.CalltrackingJobUtils.CALLTRACKING_CONFIG_BRANCH;
import static ru.yandex.direct.jobs.calltracking.CalltrackingJobUtils.PARSED_LOG_FOLDER;
import static ru.yandex.direct.jobs.calltracking.CalltrackingJobUtils.TARGET_TABLE;
import static ru.yandex.direct.jobs.calltracking.CalltrackingJobUtils.TARGET_TABLE_CLUSTER;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_1_NOT_READY;

/**
 * Джоба перекладывает данные из статических таблиц, собранных джобой {@link ParseWatchLogsCalltrackingJob}, в одну
 * общую динамическую таблицу
 */
@JugglerCheck(
        ttl = @JugglerCheck.Duration(hours = 3, minutes = 5),
        needCheck = ProductionOnly.class,
        //PRIORITY: Временно поставили приоритет по умолчанию;
        tags = {DIRECT_PRIORITY_1_NOT_READY, CheckTag.DIRECT_CALLTRACKING},
        notifications = @OnChangeNotification(
                recipient = {NotificationRecipient.CHAT_INTERNAL_SYSTEMS_MONITORING},
                method = NotificationMethod.TELEGRAM,
                status = {JugglerStatus.OK, JugglerStatus.CRIT}
        )
)
@Hourglass(periodInSeconds = 60 * 60, needSchedule = ProductionOnly.class)
public class PopulateCalltrackingDynTableJob extends PopulateDynTableJob {
    @Override
    protected String getConfigBranch() {
        return CALLTRACKING_CONFIG_BRANCH;
    }

    @Override
    protected String getTargetTable() {
        return TARGET_TABLE;
    }

    @Override
    protected YtCluster getTargetTableCluster() {
        return TARGET_TABLE_CLUSTER;
    }

    protected String getParsedLogFolder() {
        return PARSED_LOG_FOLDER;
    }

    @Autowired
    public PopulateCalltrackingDynTableJob(
            DirectConfig directConfig,
            YtProvider ytProvider,
            PpcPropertiesSupport ppcPropertiesSupport
    ) {
        super(directConfig, ytProvider,
                ppcPropertiesSupport.get(PpcPropertyNames.CALLTRACKING_NUMBER_CLICKS_POPULATE_DYN_TABLE_JOB_ENABLED));
    }

    @Override
    public YTreeMapNode convertRow(YTreeMapNode node, Long timestamp) {
        YTreeBuilder builder = YTree.mapBuilder();
        builder.key("domain").value(node.getString("domain"));
        builder.key("counterId").value(Long.parseLong(node.getString("counterId")));
        builder.key("num").value(node.getString("tel"));
        builder.key("count").value(node.getLong("clicks"));
        builder.key("timestamp").value(timestamp);
        return builder.buildMap();
    }
}
