package ru.yandex.direct.jobs.calltracking

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames
import ru.yandex.direct.config.DirectConfig
import ru.yandex.direct.env.ProductionOnly
import ru.yandex.direct.jobs.yt.PopulateDynTableJob
import ru.yandex.direct.juggler.JugglerStatus
import ru.yandex.direct.juggler.check.annotation.JugglerCheck
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification
import ru.yandex.direct.juggler.check.model.CheckTag
import ru.yandex.direct.juggler.check.model.NotificationRecipient
import ru.yandex.direct.scheduler.Hourglass
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode

/**
 * Джоба перекладывает данные из статических таблиц, собранных [ParseWatchLogsExternalCalltrackingByDomainJob],
 * в одну общую динамическую таблицу
 */
@JugglerCheck(
    ttl = JugglerCheck.Duration(hours = 3, minutes = 5),
    needCheck = ProductionOnly::class,
    tags = [CheckTag.DIRECT_PRIORITY_1_NOT_READY, CheckTag.DIRECT_CALLTRACKING],
    notifications = [
        OnChangeNotification(
            recipient = [NotificationRecipient.CHAT_INTERNAL_SYSTEMS_MONITORING],
            method = [NotificationMethod.TELEGRAM],
            status = [JugglerStatus.OK, JugglerStatus.CRIT]
        )
    ]
)
@Hourglass(periodInSeconds = 60 * 60, needSchedule = ProductionOnly::class)
class PopulateExternalCalltrackingByDomainDynTableJob(
    directConfig: DirectConfig,
    ytProvider: YtProvider,
    ppcPropertiesSupport: PpcPropertiesSupport
) : PopulateDynTableJob(
    directConfig,
    ytProvider,
    ppcPropertiesSupport.get(PpcPropertyNames.CALLTRACKING_EXTERNAL_BY_DOMAIN_POPULATE_DYN_TABLE_JOB_ENABLED)
) {
    override fun getParsedLogFolder() = CalltrackingJobUtils.PARSED_LOG_FOLDER

    override fun getTargetTableCluster() = CalltrackingJobUtils.TARGET_TABLE_CLUSTER

    override fun getConfigBranch() = CalltrackingJobUtils.EXTERNAL_CALLTRACKING_CONFIG_BRANCH

    override fun getTargetTable() = CalltrackingJobUtils.TARGET_EXTERNAL_CALLTRACKING_TABLE


    public override fun convertRow(node: YTreeMapNode, timestamp: Long): YTreeMapNode {
        val builder = YTree.mapBuilder()
        builder.key("domain").value(node.getString("domain"))
        builder.key("timestamp").value(timestamp)
        builder.key("external_calltracking").value(node.getString("script_type"))
        builder.key("hits").value(node.getLong("hits"))
        return builder.buildMap()
    }
}
