package ru.yandex.direct.jobs.calltracking;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcPropertyNames;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.jobs.yt.PopulateDynTableJob;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.juggler.check.model.CheckTag;
import ru.yandex.direct.juggler.check.model.NotificationRecipient;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

import static ru.yandex.direct.jobs.calltracking.CalltrackingJobUtils.PARSED_LOG_FOLDER;
import static ru.yandex.direct.jobs.calltracking.CalltrackingJobUtils.PHONES_WITHOUT_REPLACEMENTS_CONFIG_BRANCH;
import static ru.yandex.direct.jobs.calltracking.CalltrackingJobUtils.TARGET_TABLE_CLUSTER;
import static ru.yandex.direct.jobs.calltracking.CalltrackingJobUtils.TARGET_TABLE_PHONES_WITHOUT_REPLACEMENTS;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_2;

/**
 * Джоба перекладывает данные из статических таблиц, собранных джобой {@link ParseWatchLogsPhonesWithoutReplacementsJob},
 * в одну общую динамическую таблицу
 */
@JugglerCheck(
        ttl = @JugglerCheck.Duration(hours = 3, minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_2, CheckTag.DIRECT_CALLTRACKING},
        notifications = @OnChangeNotification(
                recipient = {NotificationRecipient.CHAT_INTERNAL_SYSTEMS_MONITORING},
                method = NotificationMethod.TELEGRAM,
                status = {JugglerStatus.OK, JugglerStatus.CRIT}
        )
)
@Hourglass(periodInSeconds = 60 * 60, needSchedule = ProductionOnly.class)
public class PopulatePhonesWithoutReplacementsDynTableJob extends PopulateDynTableJob {
    @Override
    protected String getConfigBranch() {
        return PHONES_WITHOUT_REPLACEMENTS_CONFIG_BRANCH;
    }

    @Override
    protected String getTargetTable() {
        return TARGET_TABLE_PHONES_WITHOUT_REPLACEMENTS;
    }

    @Override
    protected YtCluster getTargetTableCluster() {
        return TARGET_TABLE_CLUSTER;
    }

    protected String getParsedLogFolder() {
        return PARSED_LOG_FOLDER;
    }

    @Autowired
    public PopulatePhonesWithoutReplacementsDynTableJob(
            DirectConfig directConfig,
            YtProvider ytProvider,
            PpcPropertiesSupport ppcPropertiesSupport
    ) {
        super(directConfig, ytProvider,
                ppcPropertiesSupport.get(
                        PpcPropertyNames.PHONES_WITHOUT_REPLACEMENTS_POPULATE_DYN_TABLE_JOB_ENABLED));
    }

    @Override
    public YTreeMapNode convertRow(YTreeMapNode node, Long timestamp) {
        YTreeBuilder builder = YTree.mapBuilder();
        builder.key("clientId").value(Long.parseLong(node.getString("client_id")));
        builder.key("counterId").value(Long.parseLong(node.getString("counterid")));
        builder.key("timestamp").value(timestamp);
        builder.key("from_phone").value(node.getString("from_phone"));
        long hits = node.getLong("hits");
        long changes = node.getLong("changes");
        long unsuccessfulChanges = 0L;
        if (hits > changes) {
            unsuccessfulChanges = hits - changes;
        }
        builder.key("successful_changes").value(changes);
        builder.key("unsuccessful_changes").value(unsuccessfulChanges);
        return builder.buildMap();
    }
}
