package ru.yandex.direct.jobs.campaign;

import java.time.LocalDate;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.core.entity.StatusBsSynced;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.env.TypicalEnvironment;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.juggler.check.model.NotificationRecipient;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.support.DirectShardedJob;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_2;


@ParametersAreNonnullByDefault
@JugglerCheck(
        ttl = @JugglerCheck.Duration(hours = 48),
        tags = {DIRECT_PRIORITY_2},
        needCheck = ProductionOnly.class,
        notifications = @OnChangeNotification(
                recipient = NotificationRecipient.LOGIN_ALEX_KULAKOV,
                method = NotificationMethod.TELEGRAM,
                status = {JugglerStatus.OK, JugglerStatus.CRIT}
        )
)
@Hourglass(cronExpression = "0 0 20 * * ?", needSchedule = TypicalEnvironment.class)
public class ResendFrontpageCampaignsBeforeStartDatetoBSJob extends DirectShardedJob {

    private static final Logger logger = LoggerFactory.getLogger(ResendFrontpageCampaignsBeforeStartDatetoBSJob.class);

    CampaignRepository campaignRepository;

    public ResendFrontpageCampaignsBeforeStartDatetoBSJob(CampaignRepository campaignRepository) {
        this.campaignRepository = campaignRepository;
    }

    @Override
    public void execute() {
        int shard = getShard();
        List<Long> campaignsIdToResend = campaignRepository
                .getCampaignIdsForResendToBSToAvoidGenocide(shard, tommorow());
        campaignRepository.updateStatusBsSynced(shard, campaignsIdToResend, StatusBsSynced.NO);
        logger.info("Компании переотправленны в БК");
    }

    private LocalDate tommorow() {
        return LocalDate.now().plusDays(1);
    }
}
