package ru.yandex.direct.jobs.campaign.cpmprice.unexpectedchanges;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableList;

import ru.yandex.direct.ytwrapper.model.YtField;
import ru.yandex.direct.ytwrapper.model.YtTableRow;

@ParametersAreNonnullByDefault
public class MonitoringCpmPriceUnexpectedChangesTableRow extends YtTableRow {
    public static final YtField<Long> CID = new YtField<>("cid", Long.class);
    public static final YtField<String> REASON = new YtField<>("reason", String.class);
    public static final YtField<String> MANAGER_EMAIL = new YtField<>("manager_email", String.class);
    public static final YtField<String> MANAGER_LOGIN = new YtField<>("manager_login", String.class);
    public static final YtField<String> USER_LOGIN = new YtField<>("user_login", String.class);
    public static final YtField<String> CLIENT_NAME = new YtField<>("client_name", String.class);
    public static final YtField<String> CAMPAIGN_NAME = new YtField<>("campaign_name", String.class);
    public static final YtField<String> PRODUCT_TYPE = new YtField<>("available_ad_group_types", String.class);
    public static final YtField<String> AGGR_DATA = new YtField<>("aggr_data", String.class);

    public MonitoringCpmPriceUnexpectedChangesTableRow() {
        this(Collections.emptyList());
    }
    public MonitoringCpmPriceUnexpectedChangesTableRow(Collection<YtField> fields) {
        super(ImmutableList.<YtField>builder()
                .addAll(Arrays.asList(CID, REASON, MANAGER_EMAIL, MANAGER_LOGIN, USER_LOGIN, CAMPAIGN_NAME, PRODUCT_TYPE))
                .addAll(fields)
                .build());
    }
    public Long getCid() {
        return valueOf(CID);
    }

    public void setCid(Long cid) {
        setValue(CID, cid);
    }

    public String getReason() {
        return valueOf(REASON);
    }

    public void setReason(String reason) {
        setValue(REASON, reason);
    }

    public String getManagerEmail() {
        return valueOf(MANAGER_EMAIL);
    }

    public void setManagerEmail(String managerEmail) {
        setValue(MANAGER_EMAIL, managerEmail);
    }

    public String getManagerLogin() {
        return valueOf(MANAGER_LOGIN);
    }

    public void setManagerLogin(String managerLogin) {
        setValue(MANAGER_LOGIN, managerLogin);
    }

    public String getUserLogin() {
        return valueOf(USER_LOGIN);
    }

    public void setUserLogin(String login) {
        setValue(USER_LOGIN, login);
    }

    public String getCampaignName() {
        return valueOf(CAMPAIGN_NAME);
    }

    public void setCampaignName(String campaignName) {
        setValue(CAMPAIGN_NAME, campaignName);
    }

    public String getProductType() {
        return valueOf(PRODUCT_TYPE);
    }

    public void setProductType(String productType) {
        setValue(PRODUCT_TYPE, productType);
    }

    public String getClientName() {
        return valueOf(CLIENT_NAME);
    }

    public void setClientName(String userName) {
        setValue(CLIENT_NAME, userName);
    }

    public String getAggrData() {
        return valueOf(AGGR_DATA);
    }

    public void setAggrData(String aggrData) {
        setValue(AGGR_DATA, aggrData);
    }
}
