package ru.yandex.direct.jobs.campaign.cpmprice.unexpectedchanges;

public enum UnexpectedChangesReason {
    statusShowNo("Остановлена вручную"),
    campIsIncorrect("Кампания некорректна"),
    campIsUnexpectedlyStopped("Кампания не показывается по неизвестным причинам"),
    campIsNeverShowed("Кампания ни разу не показывалась"),
    moneyRanOut("Закончились деньги");

    private final String text;

    UnexpectedChangesReason(String text) {
        this.text = text;
    }

    public String value() {
        return name();
    }

    public static UnexpectedChangesReason fromValue(String v) {
        if (v != null) {
            return valueOf(v);
        }
        return null;
    }

    public String getText() {
        return text;
    }
}
