package ru.yandex.direct.jobs.campaign.paused.daybudget;

import java.util.Map;

import org.springframework.stereotype.Component;

import ru.yandex.direct.i18n.Language;

@Component
public class PausedByDayBudgetCampaignsWarningsMailTemplateResolver {
    private final Map<Language, String> templateMapping;

    public PausedByDayBudgetCampaignsWarningsMailTemplateResolver(Map<Language, String> templateMapping) {
        this.templateMapping = templateMapping;
    }

    public String getTemplateByLanguage(Language language) {
        return templateMapping.getOrDefault(language, templateMapping.get(Language.RU));
    }
}
