package ru.yandex.direct.jobs.campaign.paused.daybudget;

import java.util.EnumSet;
import java.util.Set;

import org.jetbrains.annotations.NotNull;

/**
 * Перечисление всех способов отправки уведомления об остановке по дневному бюджету
 */
public enum PausedByDayBudgetNotificationType {
    EVENT_LOG,
    SMS,
    EMAIL;

    private static final Set<PausedByDayBudgetNotificationType> CAMPAIGNS_MASK =
            EnumSet.of(EVENT_LOG, EMAIL);

    public static Set<PausedByDayBudgetNotificationType> retainSuitableForCampaignTypes(@NotNull Set<PausedByDayBudgetNotificationType> set) {
        set.retainAll(CAMPAIGNS_MASK);
        return set;
    }

    public static Set<PausedByDayBudgetNotificationType> retainSuitableForWalletTypes(@NotNull Set<PausedByDayBudgetNotificationType> set) {
        return set;
    }

}
