package ru.yandex.direct.jobs.campaign.repository

import ru.yandex.direct.common.spring.TestingComponent
import ru.yandex.direct.core.entity.campaign.service.validation.DeleteCampaignValidationService
import ru.yandex.direct.dbschema.ppc.Tables.BS_EXPORT_QUEUE
import ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS
import ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS_CPM_PRICE
import ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS
import ru.yandex.direct.dbschema.ppc.enums.CampaignsArchived
import ru.yandex.direct.dbschema.ppc.enums.CampaignsCpmPriceStatusApprove
import ru.yandex.direct.dbschema.ppc.enums.CampaignsCurrencyconverted
import ru.yandex.direct.dbschema.ppc.enums.CampaignsStatusempty
import ru.yandex.direct.dbschema.ppc.enums.CampaignsType
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import java.math.BigDecimal
import java.time.Duration
import java.time.LocalDateTime

@TestingComponent
class CleanTestingCampaignsRepository(
    private val dslContextProvider: DslContextProvider,
) {
    fun getCampaignsForDeletion(
        shard: Int,
        clientIds: Collection<Long>,
        cidBlacklist: Collection<Long>,
        age: Duration,
    ): List<Long> {
        return dslContextProvider.ppc(shard)
            .select(CAMPAIGNS.CID)
            .from(CAMPAIGNS)
            .join(CAMP_OPTIONS).on(CAMPAIGNS.CID.eq(CAMP_OPTIONS.CID))
            .where(
                CAMPAIGNS.CLIENT_ID.`in`(clientIds)
                    .and(CAMPAIGNS.CID.notIn(cidBlacklist))
                    .and(CAMPAIGNS.TYPE.ne(CampaignsType.wallet))
                    .and(CAMPAIGNS.STATUS_EMPTY.ne(CampaignsStatusempty.Yes))
                    .and(CAMP_OPTIONS.CREATE_TIME.le(LocalDateTime.now() - age))
            )
            .fetch(CAMPAIGNS.CID)
    }

    /**
     * Источник правды &mdash; [DeleteCampaignValidationService]
     */
    fun makeCampaignsReadyForDeletion(shard: Int, campaignIds: Collection<Long>) {
        dslContextProvider.ppc(shard)
            .update(CAMPAIGNS.leftJoin(CAMPAIGNS_CPM_PRICE).on(CAMPAIGNS.CID.eq(CAMPAIGNS_CPM_PRICE.CID)))
            .set(CAMPAIGNS.SUM, BigDecimal.ZERO)
            .set(CAMPAIGNS.SUM_TO_PAY, BigDecimal.ZERO)
            .set(CAMPAIGNS.SUM_LAST, BigDecimal.ZERO)
            .set(CAMPAIGNS.ORDER_ID, 0L)
            .set(CAMPAIGNS.CURRENCY_CONVERTED, CampaignsCurrencyconverted.No)
            .set(CAMPAIGNS_CPM_PRICE.STATUS_APPROVE, CampaignsCpmPriceStatusApprove.New)
            .set(CAMPAIGNS.ARCHIVED, CampaignsArchived.No)
            .where(CAMPAIGNS.CID.`in`(campaignIds))
            .execute()
        dslContextProvider.ppc(shard)
            .deleteFrom(BS_EXPORT_QUEUE)
            .where(BS_EXPORT_QUEUE.CID.`in`(campaignIds))
            .and(BS_EXPORT_QUEUE.PAR_ID.isNull)
            .execute()
    }
}
