package ru.yandex.direct.jobs.campaign.service;

import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.StatusReasonTextMapper;
import ru.yandex.direct.core.entity.aggregatedstatuses.campaign.AggregatedStatusCampaignData;
import ru.yandex.direct.jobs.campaign.cpmprice.unexpectedchanges.MonitoringCpmPriceUnexpectedChanges;
import ru.yandex.direct.sender.YandexSenderClient;
import ru.yandex.direct.sender.YandexSenderTemplateParams;

import static ru.yandex.direct.utils.CommonUtils.nvl;

@ParametersAreNonnullByDefault
public class CpmPriceCampaignMailSenderService {

    private final YandexSenderClient senderClient;
    protected final String defaultEmail;
    protected final boolean forceDefaultEmail;
    private final String dnaCampaignsUrl;
    protected final DirectConfig branch;

    public CpmPriceCampaignMailSenderService(
            DirectConfig config,
            YandexSenderClient senderClient) {
        this.senderClient = senderClient;
        branch = config.getBranch("cpm_price_campaign_mails");
        defaultEmail = branch.getString("DEFAULT_EMAIL");
        forceDefaultEmail = branch.getBoolean("FORCE_SEND_TO_DEFAULT_EMAIL");
        dnaCampaignsUrl = branch.getString("DNA_CAMPAIGNS_URL");
    }

    protected boolean sendEmail(@Nullable String email, String slug,
                      Map<String, String> args) {
        String toEmailOrigin = nvl(email, defaultEmail);
        String toEmail;
        toEmail = (forceDefaultEmail) ? defaultEmail : toEmailOrigin;
        var params = new YandexSenderTemplateParams.Builder()
                .withCampaignSlug(slug)
                .withToEmail(toEmail)
                .withAsync(true)
                .withArgs(args)
                .build();
        return senderClient.sendTemplate(params, YandexSenderClient::isInvalidToEmail);
    }

    protected String getUrlToViewCampaign(Long cid, String login) {
        return String.format("<a href=\"%s?campaigns-ids=%d&ulogin=%s\">%d</a>", dnaCampaignsUrl, cid, login, cid);
    }

    protected String getAggrDataReasonTranslation(AggregatedStatusCampaignData aggregatedStatus) {
        return StatusReasonTextMapper.getText(aggregatedStatus.getReasons());
    }

    protected String getCommonDebugInfo(@Nullable String email) {
        return (forceDefaultEmail) ?
                String.format("Это письмо предназначено для %s но отослано на %s, потому что включена " +
                    "соответсвующая настройка.", nvl(email, defaultEmail), defaultEmail) : "";
    }

    protected String getReason(MonitoringCpmPriceUnexpectedChanges change) {
        if (change.getAggregatedStatus().getStatus().isPresent()
                && change.getAggregatedStatus().getStatus().get() == GdSelfStatusEnum.RUN_OK) {
            return change.getReason().getText();
        }
        return getAggrDataReasonTranslation(change.getAggregatedStatus());
    }
}
