package ru.yandex.direct.jobs.campaign.service;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.sender.YandexSenderClient;

@Service
@ParametersAreNonnullByDefault
public class ResetCpmPriceCampaignFlightStatusApproveMailSenderService  extends CpmPriceCampaignMailSenderService {
    private static final Logger logger = LoggerFactory.getLogger(
            ResetCpmPriceCampaignFlightStatusApproveMailSenderService.class);

    @Autowired
    public ResetCpmPriceCampaignFlightStatusApproveMailSenderService(DirectConfig config,
            YandexSenderClient senderClient)
    {
        super(config, senderClient);
    }

    public boolean sendEmailResetFlightStatus(@Nullable String email,
            Set<Long> campaignIds,
            Map<Long, String> cidToLogin) {
        if (campaignIds.size() == 0) {
            return true;
        }
        String userNameInSubject = cidToLogin.get(campaignIds.iterator().next());
        long nLogins = EntryStream.of(cidToLogin)
                .filterKeys(campaignIds::contains)
                .values()
                .distinct()
                .count();
        if (nLogins > 1) {
            userNameInSubject += " и другие";
        }

        String campaignsHtmlTable = getCampaignsHtmlTable(campaignIds, cidToLogin);

        logger.info("Sending email to {} that status approve was reset for campaign ids {}", email, campaignIds);

        var args = Map.of("usernames_in_subject", userNameInSubject,
                "not_started_cpm_price_campaigns_list", campaignsHtmlTable,
                "ClientID", "",
                "debug_info", getCommonDebugInfo(email));

        var slug = branch.getString("STATUS_APPROVE_RESET");
        return sendEmail(email, slug, args);
    }

    private String getCampaignsHtmlTable(Collection<Long> campaignIds, Map<Long, String> cidToLogin) {
        StringBuilder html = new StringBuilder();

        html.append("<table>");
        for (var cid : campaignIds) {
            String login = cidToLogin.get(cid);
            html.append("<tr><td>")
                    .append(login)
                    .append("</td><td>")
                    .append(getUrlToViewCampaign(cid, login))
                    .append("</td></tr>");
        }
        html.append("</table>");

        return html.toString();
    }
}
