package ru.yandex.direct.jobs.canvasoperationsoncreatives.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

@ParametersAreNonnullByDefault
public enum OperationName {
    RESHOOT_SCREENSHOT("reshoot_screenshot"),
    REBUILD("rebuild"),
    SEND_TO_DIRECT("send_to_direct"),
    SEND_TO_RTBHOST("send_to_rtbhost");

    private String name;

    @JsonCreator
    OperationName(String name) {
        this.name = name;
    }

    @JsonValue
    public String getName() {
        return name;
    }
}
