package ru.yandex.direct.jobs.canvasoperationsoncreatives.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class VideoCreativesRange {

    /**
     * Номер шарда, обязательное поле
     */
    @JsonProperty("shard_id")
    private Integer shardId;

    /**
     * Нижняя граница идентификаторов креативов (включается), обязательное поле
     */
    @JsonProperty("start_id")
    private Long startId;

    /**
     * Верхняя граница идентификаторов креативов (не включается), необязательное поле
     */
    @JsonProperty("end_id")
    private Long endId;

    /**
     * Флаг завершения обработки данного шарда, необязательное поле
     */
    @JsonProperty("finished")
    private Boolean finished;

    public VideoCreativesRange(
            @JsonProperty("shard_id") Integer shardId,
            @JsonProperty("start_id") Long startId,
            @JsonProperty("end_id") @Nullable Long endId,
            @JsonProperty("finished") @Nullable Boolean finished
    ) {
        this.shardId = shardId;
        this.startId = startId;
        this.endId = endId;
        this.finished = finished;
    }

    @JsonProperty("shard_id")
    public Integer getShardId() {
        return shardId;
    }

    @JsonProperty("shard_id")
    public void setShardId(Integer shardId) {
        this.shardId = shardId;
    }

    @JsonProperty("start_id")
    public Long getStartId() {
        return startId;
    }

    @JsonProperty("start_id")
    public void setStartId(Long startId) {
        this.startId = startId;
    }

    @JsonProperty("end_id")
    public Long getEndId() {
        return endId;
    }

    @JsonProperty("end_id")
    public void setEndId(Long endId) {
        this.endId = endId;
    }

    @JsonProperty("finished")
    public Boolean getFinished() {
        return finished;
    }

    @JsonProperty("finished")
    public void setFinished(Boolean finished) {
        this.finished = finished;
    }

    @Override
    public String toString() {
        return "VideoCreativesRange{" +
                "shardId=" + shardId +
                ", startId=" + startId +
                ", endId=" + endId +
                ", finished=" + finished +
                '}';
    }
}
