package ru.yandex.direct.jobs.canvasoperationsoncreatives.model;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.creative.model.CreativeType;


@ParametersAreNonnullByDefault
public class VideoCreativesRangesList {

    /**
     * Диапазоны идентификаторов креативов по шардам, необязательное поле
     */
    @JsonProperty("ranges")
    private List<VideoCreativesRange> ranges;

    /**
     * Список операций, которые надо применить к креативам, обязательное поле
     */
    @JsonProperty("operation_names")
    private List<OperationName> operationNames;

    /**
     * Типы креативов, к которым надо применить операции из списка выше, обязательное поле
     */
    @JsonProperty("creative_types")
    private List<CreativeType> creativeTypes;

    /**
     * Размер пачки для выборки из базы, необязательное поле
     * Используется для тюнинга скорости обработки креативов,
     * полезно, потому что разные операции работают с разной скоростью
     */
    @JsonProperty("db_chunk_size")
    private Integer dbChunkSize;

    /**
     * Размер пачки на отправку в ручки canvas, необязательное поле
     * Используется для тюнинга скорости обработки креативов,
     * полезно, потому что разные операции работают с разной скоростью
     */
    @JsonProperty("request_chunk_size")
    private Integer requestChunkSize;

    public VideoCreativesRangesList(
            @JsonProperty("ranges") @Nullable List<VideoCreativesRange> ranges,
            @JsonProperty("operation_names") List<OperationName> operationNames,
            @JsonProperty("creative_types") List<CreativeType> creativeTypes,
            @JsonProperty("db_chunk_size") Integer dbChunkSize,
            @JsonProperty("request_chunk_size") Integer requestChunkSize
    ) {
        this.ranges = ranges;
        this.operationNames = operationNames;
        this.creativeTypes = creativeTypes;
        this.dbChunkSize = dbChunkSize;
        this.requestChunkSize = requestChunkSize;
    }

    @JsonProperty("ranges")
    public List<VideoCreativesRange> getRanges() {
        return ranges;
    }

    @JsonProperty("ranges")
    public void setRanges(List<VideoCreativesRange> ranges) {
        this.ranges = ranges;
    }

    @JsonProperty("operation_names")
    public List<OperationName> getOperationNames() {
        return operationNames;
    }

    @JsonProperty("operation_names")
    public void setOperationNames(List<OperationName> operationNames) {
        this.operationNames = operationNames;
    }

    @JsonProperty("creative_types")
    public List<CreativeType> getCreativeTypes() {
        return creativeTypes;
    }

    @JsonProperty("creative_types")
    public void setCreativeTypes(List<CreativeType> creativeTypes) {
        this.creativeTypes = creativeTypes;
    }

    @JsonProperty("db_chunk_size")
    public Integer getDbChunkSize() {
        return dbChunkSize;
    }

    @JsonProperty("db_chunk_size")
    public void setDbChunkSize(Integer dbChunkSize) {
        this.dbChunkSize = dbChunkSize;
    }

    @JsonProperty("request_chunk_size")
    public Integer getRequestChunkSize() {
        return requestChunkSize;
    }

    @JsonProperty("request_chunk_size")
    public void setRequestChunkSize(Integer requestChunkSize) {
        this.requestChunkSize = requestChunkSize;
    }

    @Override
    public String toString() {
        return "VideoCreativesRangesList{" +
                "ranges=" + ranges +
                ", operationNames=" + operationNames +
                ", creativeTypes=" + creativeTypes +
                ", dbChunkSize=" + dbChunkSize +
                ", requestChunkSize=" + requestChunkSize +
                '}';
    }
}
