package ru.yandex.direct.jobs.cashback;

import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.ytwrapper.model.YtField;
import ru.yandex.direct.ytwrapper.model.YtTableRow;

public class NotificationDataTableRow extends YtTableRow {
    private static final YtField<String> CLIENT_ID = new YtField<>("ClientID", String.class);
    private static final List<YtField> paramsFields = List.of(
            new YtField<>("month", String.class),
            new YtField<>("time", String.class),
            new YtField<>("subject", String.class),
            new YtField<>("template_id", String.class),
            new YtField<>("val1", String.class),
            new YtField<>("val2", String.class),
            new YtField<>("val3", Long.class),
            new YtField<>("val4", Long.class),
            new YtField<>("val5", String.class),
            new YtField<>("val7", String.class),
            new YtField<>("agency_id", Long.class),
            new YtField<>("cashback", Boolean.class),
            new YtField<>("email", String.class),
            new YtField<>("login", String.class),
            new YtField<>("clientid_str", String.class)
    );

    public ClientId getClientId() {
        return ClientId.fromLong(Long.parseLong(valueOf(CLIENT_ID)));
    }

    public Map<String, String> getParams() {
        return StreamEx.of(paramsFields)
                .mapToEntry(YtField::getName, this::valueOf)
                .nonNullValues()
                .mapValues(Object::toString)
                .toMap();
    }
}
