package ru.yandex.direct.jobs.centralizedmonitoring;

import java.io.File;
import java.util.Date;

import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;

class AuthorByFirstLineHandler implements ISVNAnnotateHandler {

    private String firstLineAuthor;

    public String getFirstLineAuthor() {
        return firstLineAuthor;
    }

    @Override
    public void handleLine(Date date, long revision, String author, String line, Date mergedDate,
                           long mergedRevision, String mergedAuthor, String mergedPath, int lineNumber) {
        if (lineNumber != 0) {
            return;
        }
        firstLineAuthor = author;
    }

    @Override
    public void handleLine(Date date, long revision, String author, String line) {
    }

    @Override
    public boolean handleRevision(Date date, long revision, String author, File contents) {
        return false;
    }

    @Override
    public void handleEOF() {
    }
}
