package ru.yandex.direct.jobs.clientavatars.gc;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcProperty;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.support.DirectShardedJob;

import static ru.yandex.direct.common.db.PpcPropertyNames.CLIENTS_AVATARS_DELETION_ENABLED;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_2;

@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 120),
        //PRIORITY: Временно поставили приоритет по умолчанию;
        tags = {DIRECT_PRIORITY_2})
@Hourglass(periodInSeconds = 3600)
public class ClientAvatarsDeleteJob extends DirectShardedJob {
    private static final Logger logger = LoggerFactory.getLogger(ClientAvatarsDeleteJob.class);
    private final PpcPropertiesSupport ppcPropertiesSupport;
    private final ClientAvatarsDeleteService clientAvatarsDeleteService;

    @Autowired
    public ClientAvatarsDeleteJob(
            PpcPropertiesSupport ppcPropertiesSupport,
            ClientAvatarsDeleteService clientAvatarsDeleteService) {
        this.ppcPropertiesSupport = ppcPropertiesSupport;
        this.clientAvatarsDeleteService = clientAvatarsDeleteService;
    }

    @Override
    public void execute() {
        PpcProperty<Boolean> jobEnabledProp = ppcPropertiesSupport.get(CLIENTS_AVATARS_DELETION_ENABLED);
        if (!jobEnabledProp.getOrDefault(false)) {
            logger.info("Skip processing. Job is not enabled. {}={}",
                    CLIENTS_AVATARS_DELETION_ENABLED,
                    jobEnabledProp.get());
            return;
        }
        int shard = getShard();
        int deletedAvatars = clientAvatarsDeleteService.doWork(shard);
        logger.info("Successfully deleted {} avatars on shard {}", deletedAvatars, shard);
    }
}
