package ru.yandex.direct.jobs.clientsdailyspent;

import java.util.List;

import ru.yandex.direct.ytwrapper.model.YtField;
import ru.yandex.direct.ytwrapper.model.YtTableRow;

class ClientsDailySpentEstimateTableRow extends YtTableRow {
    private static final YtField<Long> CLIENT_ID = new YtField<>("ClientID", Long.class);
    private static final YtField<String> TYPE = new YtField<>("type", String.class);
    private static final YtField<String> TOTAL_SUM_RUB = new YtField<>("total_sum_rub", String.class);
    private static final YtField<String> DAILY_SPENT_RUB_ESTIMATE = new YtField<>("daily_spent_rub_estimate", String.class);
    private static final YtField<String> SUM_REST_RUB = new YtField<>("sum_rest_rub", String.class);
    private static final YtField<String> ACTIVE_28DAYS_SUM_RUB = new YtField<>("active_28days_sum_rub", String.class);

    ClientsDailySpentEstimateTableRow() {
        super(List.of(CLIENT_ID, TYPE, TOTAL_SUM_RUB, ACTIVE_28DAYS_SUM_RUB, DAILY_SPENT_RUB_ESTIMATE, SUM_REST_RUB));
    }

    Long getClientId() {
        return valueOf(CLIENT_ID);
    }

    String getType() {
        return valueOf(TYPE);
    }

    String getTotalSumRub() {
        return valueOf(TOTAL_SUM_RUB);
    }

    String getDailySpentRubEstimate() {
        return valueOf(DAILY_SPENT_RUB_ESTIMATE);
    }

    String getSumRestRub() {
        return valueOf(SUM_REST_RUB);
    }

    String getActive28daysSumRub() {
        return valueOf(ACTIVE_28DAYS_SUM_RUB);
    }
}
