package ru.yandex.direct.jobs.communication;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.scheduler.support.ParametersSource;
import ru.yandex.direct.ytwrapper.model.YtCluster;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Collectors.toMap;

public class CommunicationEventSenderParametersSource implements ParametersSource<CommunicationEventSenderParam> {

    private final List<CommunicationEventSenderParam> parameters;
    private static final String SEPARATOR = "---";
    private final Map<String, CommunicationEventSenderParam> paramStringToParam;

    public CommunicationEventSenderParametersSource(DirectConfig config) {
        parameters = config.getStringList("params").stream()
                .map(config::getBranch)
                .map(this::parseParam)
                .collect(toList());


        paramStringToParam = parameters.stream()
                .collect(toMap(this::paramToString, param -> param));
    }

    private CommunicationEventSenderParam parseParam(DirectConfig paramConfig) {
        return new CommunicationEventSenderParam(
                YtCluster.parse(paramConfig.getString("cluster")),
                paramConfig.getString("path"),
                paramConfig.findString("preparing").orElse(null),
                paramConfig.findBoolean("is_default").orElse(false)
        );
    }

    @Override
    public String convertParamToString(CommunicationEventSenderParam paramValue) {
        return paramToString(paramValue);
    }

    @Override
    public CommunicationEventSenderParam convertStringToParam(String string) {
        if (!paramStringToParam.containsKey(string)) {
            throw new IllegalStateException("Unsupported parameter value " + string);
        }
        return paramStringToParam.get(string);
    }

    @Override
    public List<CommunicationEventSenderParam> getAllParamValues() {
        return parameters;
    }

    private String paramToString(CommunicationEventSenderParam param) {
        return param.getYtCluster().name() + SEPARATOR + param.getQueueFolder();
    }
}
