package ru.yandex.direct.jobs.configuration;

import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;

import ru.yandex.direct.common.configuration.MonitoringHttpServerConfiguration;
import ru.yandex.direct.scheduler.JobInterceptor;

@Configuration
@Import({
        JobsEssentialConfiguration.class,
        MonitoringHttpServerConfiguration.class,
        MySqlSlowQueryLogsConfiguration.class
})
@ComponentScan(
        basePackages = "ru.yandex.direct.jobs",
        excludeFilters = {
                @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION),
                @ComponentScan.Filter(value = JobInterceptor.class, type = FilterType.ASSIGNABLE_TYPE),
                @ComponentScan.Filter(value = VersionMismatchTerminator.class, type = FilterType.ASSIGNABLE_TYPE)
        }
)
public class DebugJobRunnerConfiguration {
}
