package ru.yandex.direct.jobs.configuration;

import ru.yandex.direct.ytwrapper.model.YtCluster;

public class GenocideLogTransferParameter {
    private final YtCluster sourceCluster;
    private final YtCluster destinationCluster;
    private final int yabsCsKey;

    public GenocideLogTransferParameter(YtCluster sourceCluster, YtCluster destinationCluster, int yabsCsKey) {
        this.sourceCluster = sourceCluster;
        this.destinationCluster = destinationCluster;
        this.yabsCsKey = yabsCsKey;
    }

    public YtCluster getSourceCluster() {
        return sourceCluster;
    }

    public YtCluster getDestinationCluster() {
        return destinationCluster;
    }

    public int getYabsCsKey() {
        return yabsCsKey;
    }

    @Override
    public String toString() {
        return "GenocideLogTransferParameter{" +
                "sourceCluster=" + sourceCluster +
                ", destinationCluster=" + destinationCluster +
                ", yabsCsKey=" + yabsCsKey +
                '}';
    }
}
