package ru.yandex.direct.jobs.configuration;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

import one.util.streamex.StreamEx;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Component;

import ru.yandex.direct.scheduler.support.ParametersSource;
import ru.yandex.direct.ytwrapper.model.YtCluster;

@Component
public class GenocideLogsTransferParametersSource implements ParametersSource<GenocideLogTransferParameter> {

    private static final String SEPARATOR = "-";
    private static final YtCluster[] YT_CLUSTERS = {YtCluster.HAHN, YtCluster.ARNOLD};
    private static final List<Integer> YABS_CS_KEYS = Arrays.asList(1, 2);

    private static final Predicate<GenocideLogTransferParameter> INSIDE_CLUSTER =
            p -> p.getSourceCluster() == p.getDestinationCluster();

    private static final List<GenocideLogTransferParameter> ALL_PARAMS =
            StreamEx.of(YT_CLUSTERS)
                    .cross(YT_CLUSTERS)
                    .mapKeyValue(Pair::of)
                    .cross(YABS_CS_KEYS)
                    .mapKeyValue((pair, key) -> new GenocideLogTransferParameter(pair.getLeft(), pair.getRight(), key))
                    .toImmutableList();

    private static final List<GenocideLogTransferParameter> INSIDE_CLUSTER_PARAMS =
            StreamEx.of(ALL_PARAMS)
                    .filter(INSIDE_CLUSTER)
                    .toImmutableList();

    private static final List<GenocideLogTransferParameter> CROSS_CLUSTER_PARAMS =
            StreamEx.of(ALL_PARAMS)
                    .filter(INSIDE_CLUSTER.negate())
                    .toImmutableList();

    public static List<GenocideLogTransferParameter> getInsideClusterParams() {
        return INSIDE_CLUSTER_PARAMS;
    }

    @Override
    public List<GenocideLogTransferParameter> getAllParamValues() {
        return CROSS_CLUSTER_PARAMS;
    }

    @Override
    public GenocideLogTransferParameter convertStringToParam(String string) {
        String[] parts = string.split(SEPARATOR);

        return new GenocideLogTransferParameter(
                YtCluster.valueOf(parts[0]),
                YtCluster.valueOf(parts[1]),
                Integer.valueOf(parts[2]));
    }

    @Override
    public String convertParamToString(GenocideLogTransferParameter paramValue) {
        return String.join(SEPARATOR,
                paramValue.getSourceCluster().name(),
                paramValue.getDestinationCluster().name(),
                String.valueOf(paramValue.getYabsCsKey())
        );
    }
}
