package ru.yandex.direct.jobs.configuration;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.TaskScheduler;

import ru.yandex.direct.common.configuration.MonitoringHttpServerConfiguration;
import ru.yandex.direct.jobs.interceptors.JobCleanerIntercepter;
import ru.yandex.direct.jobs.interceptors.JobJugglerMonitoringInterceptor;
import ru.yandex.direct.jobs.interceptors.JobLoggingInterceptor;
import ru.yandex.direct.jobs.interceptors.JobStatsInterceptor;
import ru.yandex.direct.jobs.interceptors.JobTracingInterceptor;
import ru.yandex.direct.liveresource.LiveResource;
import ru.yandex.direct.liveresource.LiveResourceFactory;
import ru.yandex.direct.liveresource.LiveResourceWatcher;
import ru.yandex.direct.liveresource.PollingLiveResourceWatcher;
import ru.yandex.direct.scheduler.JobInterceptorsList;
import ru.yandex.direct.scheduler.configuration.SchedulerConfiguration;

import static ru.yandex.direct.common.configuration.CommonConfiguration.LIVE_CONFIG_CHECK_RATE;
import static ru.yandex.direct.config.EssentialConfiguration.CONFIG_SCHEDULER_BEAN_NAME;


@Configuration
@Import({
        JobsEssentialConfiguration.class,
        SchedulerConfiguration.class,
        HourglassConfiguration.class,
        MonitoringHttpServerConfiguration.class,
        MySqlSlowQueryLogsConfiguration.class,
})
@ComponentScan(
        basePackages = "ru.yandex.direct.jobs",
        excludeFilters = @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION)
)
public class JobsConfiguration {

    @Bean
    @Autowired
    public LiveResourceWatcher schedulerVersionWatcher(
            @Qualifier(CONFIG_SCHEDULER_BEAN_NAME) TaskScheduler liveConfigChangeTaskScheduler,
            @Value("${scheduler.version_file}") String schedulerConfig) {
        LiveResource resource = LiveResourceFactory.get(schedulerConfig);
        return new PollingLiveResourceWatcher(resource,
                resource.getContent(),
                liveConfigChangeTaskScheduler,
                LIVE_CONFIG_CHECK_RATE);
    }

    @Bean
    JobInterceptorsList jobInterceptorsList(JobTracingInterceptor tracing, JobLoggingInterceptor logging,
                                            JobJugglerMonitoringInterceptor juggler, JobStatsInterceptor stats,
                                            JobCleanerIntercepter cleaner) {
        return new JobInterceptorsList(
                logging,
                tracing,
                juggler,
                stats,
                cleaner
        );
    }

}
